/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.actions;

import minetweaker.IUndoableAction;
import modtweaker.brackets.util.IMaterial;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class SetHarvestLevelAction
implements IUndoableAction {
    private final IMaterial material;
    private final String stat;
    private final int newValue;
    private final int oldValue;

    public SetHarvestLevelAction(IMaterial material, String stat, int newValue) {
        this.material = material;
        this.stat = stat;
        this.newValue = newValue;
        this.oldValue = ((HeadMaterialStats)((Material)material.getInternal()).getStats((String)"head")).harvestLevel;
    }

    private static void set(Material material, String stat, int level) {
        IMaterialStats oldStat = material.getStats(stat);
        if (oldStat instanceof HeadMaterialStats) {
            HeadMaterialStats headStat = (HeadMaterialStats)oldStat;
            HeadMaterialStats newHead = new HeadMaterialStats(headStat.durability, headStat.miningspeed, headStat.attack, level);
            material.addStats((IMaterialStats)newHead);
        }
    }

    public void apply() {
        SetHarvestLevelAction.set((Material)this.material.getInternal(), this.stat, this.newValue);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        SetHarvestLevelAction.set((Material)this.material.getInternal(), this.stat, this.oldValue);
    }

    public String describe() {
        return "Setting durability of " + this.material.getName() + " to " + this.newValue + " for " + this.stat;
    }

    public String describeUndo() {
        return "Reverting durability of " + this.material.getName() + " to " + this.oldValue + " for " + this.stat;
    }

    public Object getOverrideKey() {
        return null;
    }
}

