/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.randomthings.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.List;
import lumien.randomthings.recipes.imbuing.ImbuingRecipe;
import lumien.randomthings.recipes.imbuing.ImbuingRecipeHandler;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.randomthings.ImbuingStation")
public class ImbuingStation {
    @ZenMethod
    public static void add(IItemStack output, IItemStack input, IItemStack ingredient1, IItemStack ingredient2, IItemStack ingredient3) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new ImbuingRecipe(InputHelper.toStack((IItemStack)input), InputHelper.toStack((IItemStack)output), new ItemStack[]{InputHelper.toStack((IItemStack)ingredient1), InputHelper.toStack((IItemStack)ingredient2), InputHelper.toStack((IItemStack)ingredient3)})));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(new ImbuingRecipe(null, InputHelper.toStack((IItemStack)output), new ItemStack[]{null, null, null})));
    }

    private static class Remove
    extends BaseListRemoval<ImbuingRecipe> {
        protected Remove(ImbuingRecipe recipe) {
            super("ImbuingStation", (List)ImbuingRecipeHandler.imbuingRecipes);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (ImbuingRecipe recipe : this.recipes) {
                if (recipe != null) {
                    ImbuingRecipe toRemove = null;
                    for (ImbuingRecipe r : ImbuingRecipeHandler.imbuingRecipes) {
                        if (!r.getResult().func_77969_a(recipe.getResult())) continue;
                        toRemove = r;
                    }
                    if (toRemove == null) continue;
                    if (ImbuingRecipeHandler.imbuingRecipes.remove(toRemove)) {
                        this.successful.add(recipe);
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(ImbuingRecipe recipe) {
            StringBuilder build = new StringBuilder();
            build.append(LogHelper.getStackDescription((Object)recipe.getResult()) + ", ");
            for (ItemStack stack : recipe.getIngredients()) {
                build.append(LogHelper.getStackDescription((Object)stack) + " ");
            }
            return build.toString();
        }
    }

    private static class Add
    extends BaseListAddition<ImbuingRecipe> {
        protected Add(ImbuingRecipe recipe) {
            super("ImbuingStation", (List)ImbuingRecipeHandler.imbuingRecipes);
            this.recipes.add(recipe);
        }

        protected String getRecipeInfo(ImbuingRecipe recipe) {
            StringBuilder build = new StringBuilder();
            build.append(LogHelper.getStackDescription((Object)recipe.getResult()));
            build.append(LogHelper.getStackDescription((Object)recipe.toImbue()));
            for (ItemStack stack : recipe.getIngredients()) {
                build.append(LogHelper.getStackDescription((Object)stack));
            }
            return build.toString();
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (ImbuingRecipe recipe : this.successful) {
                if (recipe != null) {
                    ImbuingRecipe toRemove = null;
                    for (ImbuingRecipe r : ImbuingRecipeHandler.imbuingRecipes) {
                        if (!r.getResult().func_77969_a(recipe.getResult())) continue;
                        toRemove = r;
                    }
                    if (toRemove == null || ImbuingRecipeHandler.imbuingRecipes.remove(toRemove)) continue;
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }
    }
}

