/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.botania.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1102.item.MCItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.client.integration.jei.elventrade.ElvenTradeRecipeWrapper;

@ZenClass(value="mods.botania.ElvenTrade")
public class ElvenTrade {
    protected static final String name = "Botania Eleven Trade";

    @ZenMethod
    public static void addRecipe(IItemStack[] outputs, IIngredient[] input) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeElvenTrade(InputHelper.toStacks((IItemStack[])outputs), InputHelper.toObjects((IIngredient[])input))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipeElvenTrade> recipes = new LinkedList<RecipeElvenTrade>();
        for (RecipeElvenTrade entry : BotaniaAPI.elvenTradeRecipes) {
            if (entry == null || entry.getOutputs() == null || !StackHelper.matches((IIngredient)output, (IItemStack[])ElvenTrade.toStacks(entry.getOutputs().toArray(new ItemStack[entry.getOutputs().size()])))) continue;
            recipes.add(entry);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    public static IItemStack[] toStacks(ItemStack[] iIngredient) {
        ArrayList<MCItemStack> stacks = new ArrayList<MCItemStack>();
        for (ItemStack stack : iIngredient) {
            stacks.add(new MCItemStack(stack));
        }
        return stacks.toArray(new IItemStack[stacks.size()]);
    }

    private static class Remove
    extends BaseListRemoval<RecipeElvenTrade> {
        public Remove(List<RecipeElvenTrade> recipes) {
            super(ElvenTrade.name, BotaniaAPI.elvenTradeRecipes, recipes);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new ElvenTradeRecipeWrapper(rec)));
        }

        public void undo() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new ElvenTradeRecipeWrapper(rec)));
        }

        public String getRecipeInfo(RecipeElvenTrade recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutputs());
        }
    }

    private static class Add
    extends BaseListAddition<RecipeElvenTrade> {
        public Add(RecipeElvenTrade recipe) {
            super(ElvenTrade.name, BotaniaAPI.elvenTradeRecipes);
            this.recipes.add(recipe);
        }

        public void apply() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new ElvenTradeRecipeWrapper(rec)));
        }

        public void undo() {
            super.apply();
            this.successful.forEach(rec -> MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new ElvenTradeRecipeWrapper(rec)));
        }

        public String getRecipeInfo(RecipeElvenTrade recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutputs());
        }
    }
}

