/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.botania.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StringHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeBrew;

@ZenClass(value="mods.botania.Brew")
public class Brew {
    public static final String name = "Botania Brew";

    @ZenMethod
    public static void addRecipe(IIngredient[] inputItems, String brewName) {
        if (inputItems == null || inputItems.length == 0 || brewName == null || brewName.length() == 0) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (!BotaniaAPI.brewMap.containsKey(brewName)) {
            LogHelper.logError((String)String.format("Unknown brew name \"%s\" for %s recipe.", brewName, name));
        }
        RecipeBrew recipe = new RecipeBrew((vazkii.botania.api.brew.Brew)BotaniaAPI.brewMap.get(brewName), InputHelper.toObjects((IIngredient[])inputItems));
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(String brewName) {
        LinkedList<RecipeBrew> recipes = new LinkedList<RecipeBrew>();
        Matcher matcher = Pattern.compile(StringHelper.wildcardToRegex((String)brewName)).matcher("");
        for (RecipeBrew recipe : BotaniaAPI.brewRecipes) {
            matcher.reset(recipe.getBrew().getKey());
            if (!matcher.matches()) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s recipe found for %s. Command ignored!", name, brewName));
        }
    }

    public static class Remove
    extends BaseListRemoval<RecipeBrew> {
        protected Remove(List<RecipeBrew> recipes) {
            super(Brew.name, BotaniaAPI.brewRecipes, recipes);
        }

        protected String getRecipeInfo(RecipeBrew recipe) {
            return recipe.getBrew().getKey();
        }
    }

    private static class Add
    extends BaseListAddition<RecipeBrew> {
        protected Add(RecipeBrew recipe) {
            super(Brew.name, BotaniaAPI.brewRecipes);
            this.recipes.add(recipe);
        }

        protected String getRecipeInfo(RecipeBrew recipe) {
            return recipe.getBrew().getKey();
        }
    }
}

