/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.actuallyadditions.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CompostRecipe;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.actuallyadditions.Compost")
public class Compost {
    protected static final String name = "Actually Additions Compost";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        if (!InputHelper.isABlock((IItemStack)input) || !InputHelper.isABlock((IItemStack)output)) {
            LogHelper.logWarning((String)String.format("Invalid %s Recipe found for %s. Input and output must be blocks.", "Actually Additions Empowerer", output.toString()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CompostRecipe(InputHelper.toStack((IItemStack)input), Block.func_149634_a((Item)InputHelper.toStack((IItemStack)input).func_77973_b()), InputHelper.toStack((IItemStack)output), Block.func_149634_a((Item)InputHelper.toStack((IItemStack)output).func_77973_b()))));
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack displayInput, IItemStack output, IItemStack displayOutput) {
        if (!InputHelper.isABlock((IItemStack)displayInput) || !InputHelper.isABlock((IItemStack)displayOutput)) {
            LogHelper.logWarning((String)String.format("Invalid %s Recipe found for %s. Input and output must be blocks.", "Actually Additions Empowerer", output.toString()));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CompostRecipe(InputHelper.toStack((IItemStack)input), Block.func_149634_a((Item)InputHelper.toStack((IItemStack)displayInput).func_77973_b()), InputHelper.toStack((IItemStack)output), Block.func_149634_a((Item)InputHelper.toStack((IItemStack)displayOutput).func_77973_b()))));
    }

    @ZenMethod
    public static void remove(IIngredient input) {
        LinkedList<CompostRecipe> recipes = new LinkedList<CompostRecipe>();
        if (input == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (CompostRecipe recipe : ActuallyAdditionsAPI.COMPOST_RECIPES) {
            if (!StackHelper.matches((IIngredient)input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.input))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<CompostRecipe> {
        public Remove(List<CompostRecipe> recipes) {
            super(Compost.name, ActuallyAdditionsAPI.COMPOST_RECIPES, recipes);
        }

        protected String getRecipeInfo(CompostRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.output);
        }
    }

    private static class Add
    extends BaseListAddition<CompostRecipe> {
        public Add(CompostRecipe recipe) {
            super(Compost.name, ActuallyAdditionsAPI.COMPOST_RECIPES);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(CompostRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.output);
        }
    }
}

