/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.events.ClientGuideEvent;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.guide.GuideFormat;
import com.feed_the_beast.ftbl.api.guide.GuideType;
import com.feed_the_beast.ftbl.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiGuide;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.guide.GuideContentsLine;
import com.feed_the_beast.ftbl.lib.guide.GuideHrLine;
import com.feed_the_beast.ftbl.lib.guide.GuideListLine;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.guide.GuideTextLineString;
import com.feed_the_beast.ftbl.lib.guide.GuideTitlePage;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;

public enum Guides implements IResourceManagerReloadListener
{
    INSTANCE;

    private static final GuidePage INFO_PAGE;
    private static boolean isReloading;
    private static Thread reloadingThread;
    private static GuiGuide cachedGui;
    public static final Map<String, String> SUBSTITUTE_CACHE;

    public static void setShouldReload() {
        cachedGui = null;
    }

    public static void refresh() {
        GuiHelper.playClickSound();
        Guides.setShouldReload();
        Guides.openGui();
    }

    public static void openGui() {
        if (cachedGui == null) {
            if (!isReloading) {
                isReloading = true;
                new GuiLoading(){

                    public void startLoading() {
                        reloadingThread = new Thread(() -> {
                            INSTANCE.func_110549_a(Minecraft.func_71410_x().func_110442_L());
                            isReloading = false;
                        });
                        reloadingThread.start();
                    }

                    public boolean isLoading() {
                        return isReloading;
                    }

                    public void finishLoading() {
                        reloadingThread = null;
                        cachedGui = new GuiGuide(INFO_PAGE);
                        cachedGui.openGui();
                    }
                }.openGui();
            }
        } else if (!isReloading) {
            cachedGui.openGui();
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        FTBUFinals.LOGGER.info("Reloading guides...");
        INFO_PAGE.clear();
        INFO_PAGE.setTitle((ITextComponent)new TextComponentString("Guides"));
        ArrayList<Object> guides = new ArrayList<Object>();
        SUBSTITUTE_CACHE.clear();
        for (String domain : resourceManager.func_135055_a()) {
            try {
                IResource iResource = resourceManager.func_110536_a(new ResourceLocation(domain, "guide.json"));
                JsonElement infoFile = JsonUtils.fromJson((Reader)new InputStreamReader(iResource.func_110527_b()));
                if (!infoFile.isJsonObject()) continue;
                GuideTitlePage guide = new GuideTitlePage(domain, infoFile.getAsJsonObject());
                GuideFormat format = guide.getFormat();
                if (format == GuideFormat.UNSUPPORTED) {
                    guide.println((Object)"Unsupported format!");
                    guide.println((Object)"Please update FTBUtilities or contact mod author!");
                } else {
                    Guides.loadTree(resourceManager, domain, (GuidePage)guide, format, "guide");
                    if (guide.childPages.size() > 0) {
                        guide.println((Object)new GuideHrLine(1, Color4I.NONE));
                        guide.println((Object)new GuideContentsLine((GuidePage)guide));
                    }
                }
                guides.add(guide);
            }
            catch (Exception exception) {
                if (exception instanceof FileNotFoundException) continue;
                exception.printStackTrace();
            }
        }
        HashMap eventMap = new HashMap();
        MinecraftForge.EVENT_BUS.post((Event)new ClientGuideEvent(eventMap, resourceManager, modid -> {
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
            if (mod == null) {
                return new GuideTitlePage(modid, GuideType.MOD, Collections.emptyList(), Collections.singleton("Autogenerated"));
            }
            return new GuideTitlePage(mod);
        }));
        guides.addAll(eventMap.values());
        for (GuideTitlePage guideTitlePage : guides) {
            INFO_PAGE.addSub((GuidePage)guideTitlePage);
        }
        INFO_PAGE.cleanup();
        INFO_PAGE.sort(false);
    }

    private static boolean validChar(char c) {
        return c == '_' || c == '.' || c == '{' || c == '}' || StringUtils.isTextChar((char)c, (boolean)true);
    }

    private static void loadTree(IResourceManager resourceManager, String domain, GuidePage page, GuideFormat format, String parentDir) throws Exception {
        block20: {
            block19: {
                List<String> text = Collections.emptyList();
                try {
                    switch (format) {
                        case JSON: {
                            text = Collections.singletonList(Guides.replaceSubstitutes(StringUtils.readString((InputStream)resourceManager.func_110536_a(new ResourceLocation(domain, parentDir + "/index.json")).func_110527_b())).replace("\\$", "$"));
                            for (JsonElement e : JsonUtils.fromJson((String)text.get(0)).getAsJsonArray()) {
                                page.println((Object)page.createLine(e));
                            }
                            break;
                        }
                        case MD: {
                            text = StringUtils.readStringList((InputStream)resourceManager.func_110536_a(new ResourceLocation(domain, parentDir + "/README.md")).func_110527_b());
                            for (String s : text) {
                                page.println((Object)s);
                            }
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex instanceof FileNotFoundException) break block19;
                    page.getTitle().func_150256_b().func_150238_a(TextFormatting.RED);
                    page.println((Object)"Error:");
                    page.println((Object)ex);
                    if (text.isEmpty()) break block19;
                    page.println(null);
                    page.println((Object)"Source:");
                    ArrayList<GuideTextLineString> lines = new ArrayList<GuideTextLineString>();
                    for (String s : text) {
                        for (String s1 : s.split("\\r?\\n")) {
                            lines.add(new GuideTextLineString(s1));
                        }
                    }
                    page.println((Object)new GuideListLine(lines, GuideListLine.Type.CODE, GuideListLine.Ordering.NUMBER, 0));
                }
            }
            try {
                for (JsonElement e : JsonUtils.fromJson((Reader)new InputStreamReader(resourceManager.func_110536_a(new ResourceLocation(domain, parentDir + "/pages.json")).func_110527_b())).getAsJsonArray()) {
                    GuidePage page1;
                    if (e.isJsonObject()) {
                        JsonObject o = e.getAsJsonObject();
                        page1 = page.getSub(o.get("id").getAsString());
                        if (o.has("icon")) {
                            page1.setIcon(ImageProvider.get((JsonElement)o.get("icon")));
                        }
                        if (o.has("button")) {
                            page1.addSpecialButton(new SpecialGuideButton(o.get("button").getAsJsonObject()));
                        }
                        if (o.has("lang")) {
                            page1.setTitle((ITextComponent)new TextComponentTranslation(o.get("lang").getAsString(), new Object[0]));
                        } else {
                            page1.setTitle((ITextComponent)new TextComponentTranslation(domain + '.' + parentDir.replace('/', '.') + "." + page1.func_176610_l(), new Object[0]));
                        }
                    } else {
                        page1 = page.getSub(e.getAsString());
                        page1.setTitle((ITextComponent)new TextComponentTranslation(domain + '.' + parentDir.replace('/', '.') + "." + page1.func_176610_l(), new Object[0]));
                    }
                    Guides.loadTree(resourceManager, domain, page1, format, parentDir + "/" + page1.func_176610_l());
                }
            }
            catch (Exception ex) {
                if (!LMUtils.DEV_ENV || ex instanceof FileNotFoundException) break block20;
                ex.printStackTrace();
            }
        }
    }

    private static String replaceSubstitutes(CharSequence text) {
        StringBuilder builder = new StringBuilder();
        StringBuilder keyBuilder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (keyBuilder.length() > 0) {
                if (Guides.validChar(c)) {
                    keyBuilder.append(c);
                    continue;
                }
                String value = SUBSTITUTE_CACHE.computeIfAbsent(keyBuilder.substring(1), k -> Guides.replaceSubstitutes(StringUtils.translate((String)k).replace('\u201c', '\"').replace('\u201d', '\"').replace("\"", "\\\"")));
                builder.append(value);
                if (c != '$') {
                    builder.append(c);
                }
                keyBuilder.setLength(0);
                continue;
            }
            if (c == '$' && (i < 1 || text.charAt(i - 1) != '\\')) {
                keyBuilder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString().replace("\t", "  ");
    }

    static {
        INFO_PAGE = new GuidePage("guides").addSpecialButton(new SpecialGuideButton(GuiLang.BUTTON_REFRESH.textComponent(new Object[0]), (IDrawableObject)GuiIcons.REFRESH, new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbc refresh_guide")));
        isReloading = false;
        reloadingThread = null;
        cachedGui = null;
        SUBSTITUTE_CACHE = new HashMap<String, String>();
    }
}

