/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunkStorage;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class CmdLoadedChunks
extends CmdBase {
    public CmdLoadedChunks() {
        super("loaded_chunks_list", CmdBase.Level.ALL);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP ep = CmdLoadedChunks.func_71521_c((ICommandSender)sender);
        GuidePage page = new GuidePage("loaded_chunks").setTitle((ITextComponent)new TextComponentString("Loaded Chunks"));
        for (WorldServer w : DimensionManager.getWorlds()) {
            ImmutableSetMultimap map = ForgeChunkManager.getPersistentChunksFor((World)w);
            HashMap chunksMap = new HashMap();
            for (ForgeChunkManager.Ticket t : map.values()) {
                HashSet<ChunkPos> list = (HashSet<ChunkPos>)chunksMap.get(t.getModId());
                if (list == null) {
                    list = new HashSet<ChunkPos>();
                    chunksMap.put(t.getModId(), list);
                }
                for (ChunkPos c : t.getChunkList()) {
                    if (list.contains(c)) continue;
                    list.add(c);
                }
            }
            int dimId = w.field_73011_w.getDimension();
            GuidePage dim = page.getSub(Integer.toString(dimId)).setTitle((ITextComponent)new TextComponentString(w.field_73011_w.func_186058_p().func_186065_b() + " [" + (dimId == 0 ? "DIM0" : w.field_73011_w.getSaveFolder()) + "]"));
            for (Map.Entry e1 : chunksMap.entrySet()) {
                GuidePage mod = dim.getSub((String)e1.getKey()).setTitle((ITextComponent)new TextComponentString((String)e1.getKey() + " [" + ((Collection)e1.getValue()).size() + "]"));
                for (ChunkPos c : (Collection)e1.getValue()) {
                    StringBuilder owner = new StringBuilder();
                    IClaimedChunk chunk = ClaimedChunkStorage.INSTANCE.getChunk(new ChunkDimPos(c, dimId));
                    if (chunk != null) {
                        owner = new StringBuilder(chunk.getOwner().getName());
                    } else {
                        for (ForgeChunkManager.Ticket t : map.get((Object)c)) {
                            if (!t.isPlayerTicket()) continue;
                            if (owner.length() > 0) {
                                owner.append(", ");
                            }
                            owner.append(t.getPlayerName());
                        }
                    }
                    if (owner.length() == 0) {
                        owner = new StringBuilder("Unknown");
                    }
                    TextComponentString line = new TextComponentString(c.field_77276_a + ", " + c.field_77275_b + " [" + owner + "]");
                    int cx = (c.field_77276_a << 4) + 8;
                    int cz = (c.field_77275_b << 4) + 8;
                    String cmd = "/tp " + cx + " " + ep.field_70170_p.func_189649_b(cx, cz) + " " + cz;
                    line.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(cmd)));
                    line.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd));
                    mod.println((Object)line);
                }
            }
        }
        page.cleanup();
        FTBLibIntegration.API.displayGuide((EntityPlayer)ep, page);
    }
}

