/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api_impl;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.EnumTeamPrivacyLevel;
import com.feed_the_beast.ftbl.lib.math.BlockPosContainer;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunkStorage;
import com.feed_the_beast.ftbu.world.FTBUTeamData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;

public enum ClaimedChunkStorage implements IClaimedChunkStorage
{
    INSTANCE;

    private static final Map<ChunkDimPos, IClaimedChunk> MAP;
    private static final Map<ChunkDimPos, IClaimedChunk> MAP_MIRROR;

    public void init() {
        this.clear();
    }

    public void clear() {
        MAP.clear();
    }

    @Override
    @Nullable
    public IClaimedChunk getChunk(ChunkDimPos pos) {
        return MAP.get(pos);
    }

    @Override
    public void setChunk(ChunkDimPos pos, @Nullable IClaimedChunk chunk) {
        if (chunk == null) {
            MAP.remove(pos);
        } else {
            MAP.put(pos, chunk);
        }
    }

    @Override
    public Collection<IClaimedChunk> getChunks(@Nullable IForgePlayer owner) {
        if (MAP.isEmpty()) {
            return Collections.emptyList();
        }
        if (owner == null) {
            return MAP_MIRROR.values();
        }
        ArrayList<IClaimedChunk> c = new ArrayList<IClaimedChunk>();
        MAP.forEach((key, value) -> {
            if (value.getOwner().equalsPlayer(owner)) {
                c.add((IClaimedChunk)value);
            }
        });
        return c;
    }

    @Override
    public boolean canPlayerInteract(EntityPlayerMP ep, EnumHand hand, BlockPosContainer block, BlockInteractionType type) {
        if (FTBUPermissions.canModifyBlock(ep, hand, block, type)) {
            return true;
        }
        IClaimedChunk chunk = this.getChunk(new ChunkDimPos(block.getPos(), ep.field_71093_bK));
        if (chunk == null) {
            return true;
        }
        IForgePlayer player = FTBLibIntegration.API.getUniverse().getPlayer((Object)ep);
        if (chunk.getOwner().equalsPlayer(player)) {
            return true;
        }
        IForgeTeam team = chunk.getOwner().getTeam();
        if (team == null) {
            return true;
        }
        if (player.isFake()) {
            return FTBUTeamData.get((IForgeTeam)team).fakePlayers.getBoolean();
        }
        return team.canInteract(player.getId(), (EnumTeamPrivacyLevel)FTBUTeamData.get((IForgeTeam)team).blocks.getNonnull());
    }

    static {
        MAP = new HashMap<ChunkDimPos, IClaimedChunk>();
        MAP_MIRROR = Collections.unmodifiableMap(MAP);
    }
}

