/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IUniverse;
import com.feed_the_beast.ftbl.api.events.ServerInfoEvent;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.client.DrawableItem;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.InvertedComparator;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.FTBLibIntegration;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.FTBULeaderboards;
import com.feed_the_beast.ftbu.Leaderboard;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.config.FTBUConfigGeneral;
import com.feed_the_beast.ftbu.ranks.CmdOverride;
import com.feed_the_beast.ftbu.ranks.Ranks;
import com.feed_the_beast.ftbu.world.FTBUUniverseData;
import com.feed_the_beast.ftbu.world.backups.Backups;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.permission.PermissionAPI;

public class ServerInfoPage {
    private static final GuidePage CACHED_PAGE = new GuidePage("server_info").setTitle((ITextComponent)new TextComponentTranslation("sidebar_button.ftbu.server_info", new Object[0]));

    public static void reloadCachedInfo() {
        CACHED_PAGE.clear();
    }

    public static GuidePage getPageForPlayer(EntityPlayer ep) {
        IUniverse universe = FTBLibIntegration.API.getUniverse();
        Preconditions.checkNotNull((Object)universe, (Object)"World can't be null!");
        IForgePlayer self = universe.getPlayer((Object)ep);
        Preconditions.checkNotNull((Object)self, (Object)"Player can't be null!");
        GuidePage page = new GuidePage(CACHED_PAGE.func_176610_l());
        page.setTitle(CACHED_PAGE.getTitle());
        page.copyFrom(CACHED_PAGE);
        MinecraftServer server = ServerUtils.getServer();
        boolean isDedi = server.func_71262_S();
        boolean isOP = !isDedi || PermissionAPI.hasPermission((EntityPlayer)ep, (String)"ftbu.display.admin_info");
        FTBUUniverseData ftbuUniverseData = FTBUUniverseData.get();
        ArrayList players = new ArrayList();
        players.addAll(universe.getPlayers());
        if (FTBUConfigGeneral.AUTO_RESTART.getBoolean()) {
            page.println((Object)FTBULang.TIMER_RESTART.textComponent(new Object[]{StringUtils.getTimeString((long)(ftbuUniverseData.restartMillis - System.currentTimeMillis()))}));
        }
        if (FTBUConfigBackups.ENABLED.getBoolean()) {
            page.println((Object)FTBULang.TIMER_BACKUP.textComponent(new Object[]{StringUtils.getTimeString((long)(Backups.INSTANCE.nextBackup - System.currentTimeMillis()))}));
        }
        if (FTBUConfigGeneral.SERVER_INFO_DIFFICULTY.getBoolean()) {
            page.println((Object)FTBLibLang.DIFFICULTY.textComponent(new Object[]{StringUtils.firstUppercase((String)ep.field_70170_p.func_175659_aa().toString().toLowerCase())}));
        }
        if (FTBUConfigGeneral.SERVER_INFO_MODE.getBoolean()) {
            page.println((Object)FTBLibLang.MODE_CURRENT.textComponent(new Object[]{StringUtils.firstUppercase((String)FTBLibIntegration.API.getServerData().getPackMode().func_176610_l())}));
        }
        if (FTBUConfigGeneral.SERVER_INFO_ADMIN_QUICK_ACCESS.getBoolean()) {
            // empty if block
        }
        GuidePage page1 = page.getSub("leaderboards").setTitle(FTBULeaderboards.LANG_LEADERBOARD_TITLE.textComponent(new Object[0]));
        page1.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Items.field_151155_ap)));
        for (Leaderboard leaderboard : FTBUCommon.LEADERBOARDS) {
            GuidePage thisTop = page1.getSub(leaderboard.stat.field_75975_e).setTitle(leaderboard.name);
            thisTop.setIcon(leaderboard.icon);
            players.sort(new InvertedComparator(leaderboard.comparator));
            int size = Math.min(players.size(), FTBUConfigGeneral.MAX_LEADERBOARD_SIZE.getInt());
            for (int j = 0; j < size; ++j) {
                IForgePlayer p = (IForgePlayer)players.get(j);
                Object data = leaderboard.data.getData(p);
                if (data == null) {
                    data = "[null]";
                }
                StringBuilder sb = new StringBuilder();
                sb.append('[');
                sb.append(j + 1);
                sb.append(']');
                sb.append(' ');
                sb.append(p.getName());
                sb.append(':');
                sb.append(' ');
                if (!(data instanceof ITextComponent)) {
                    sb.append(data);
                }
                TextComponentString c = new TextComponentString(sb.toString());
                if (p == self) {
                    c.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
                } else if (j < 3) {
                    c.func_150256_b().func_150238_a(TextFormatting.LIGHT_PURPLE);
                }
                if (data instanceof ITextComponent) {
                    c.func_150257_a(ServerUtils.getChatComponent((Object)data));
                }
                thisTop.println((Object)c);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ServerInfoEvent(page, self, isOP));
        page1 = page.getSub("commands").setTitle(FTBLibLang.COMMANDS.textComponent(new Object[0]));
        page1.setIcon((IDrawableObject)new DrawableItem(new ItemStack(Blocks.field_150483_bI)));
        try {
            for (ICommand c : ServerUtils.getAllCommands((MinecraftServer)server, (ICommandSender)ep)) {
                try {
                    ServerInfoPage.addCommandUsage((ICommandSender)ep, page1.getSub(c.func_71517_b()), 0, c);
                }
                catch (Exception ex1) {
                    TextComponentString cc = new TextComponentString('/' + c.func_71517_b());
                    cc.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                    page1.getSub('/' + c.func_71517_b()).setTitle((ITextComponent)cc).println((Object)"Errored");
                    if (!LMUtils.DEV_ENV) continue;
                    ex1.printStackTrace();
                }
            }
            page1.sort(true);
        }
        catch (Exception ex) {
            page1.println((Object)"Failed to load commands");
        }
        if (PermissionAPI.hasPermission((EntityPlayer)ep, (String)"ftbu.display.permissions")) {
            page.addSub(Ranks.INFO_PAGE);
        }
        page.cleanup();
        page.sort(false);
        return page;
    }

    private static void addCommandUsage(ICommandSender sender, GuidePage page, int level, ICommand c) {
        page.println((Object)('/' + c.func_71517_b()));
        for (String s : c.func_71514_a()) {
            page.println((Object)('/' + s));
        }
        page.println(null);
        for (String s : c.func_71518_a(sender).split("\n")) {
            if (s.indexOf(37) != -1 || s.indexOf(47) != -1) {
                page.println((Object)new TextComponentTranslation("commands.generic.usage", new Object[]{s}));
                continue;
            }
            page.println((Object)new TextComponentTranslation("commands.generic.usage", new Object[]{new TextComponentTranslation(s, new Object[0])}));
        }
        CommandTreeBase treeCommand = null;
        if (c instanceof CommandTreeBase) {
            treeCommand = (CommandTreeBase)c;
        } else if (c instanceof CmdOverride && ((CmdOverride)c).parent instanceof CommandTreeBase) {
            treeCommand = (CommandTreeBase)((CmdOverride)c).parent;
        }
        if (treeCommand != null) {
            for (ICommand command : treeCommand.getSubCommands()) {
                ServerInfoPage.addCommandUsage(sender, page.getSub(command.func_71517_b()), level + 1, command);
            }
        }
    }
}

