/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.multiblock;

import com.valkyrieofnight.valkyrielib.multiblock.IControllerTile;
import com.valkyrieofnight.valkyrielib.multiblock.ISlaveTile;
import com.valkyrieofnight.valkyrielib.multiblock.structure.MultiBlockStructure;
import com.valkyrieofnight.valkyrielib.tileentity.VLTileEntity;
import com.valkyrieofnight.valkyrielib.util.IDebuggable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class VLTileController
extends VLTileEntity
implements IControllerTile,
ITickable,
IDebuggable {
    protected int mbDirection = -1;
    private boolean isFormed = false;
    private boolean isProcessing = false;
    private int currentDuration = 0;
    private int currentProgress = 0;
    private int ticker = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.ticker;
            if (this.ticker % 60 == 0) {
                if (!this.isFormed) {
                    this.mbDirection = this.getStructure().verifyLayoutAndGetDirection(this.field_145850_b, this.func_174877_v());
                    if (this.mbDirection != -1) {
                        this.getStructure().assignMultiblock(this.field_145850_b, this.func_174877_v(), this.getStructure().getSlavePositions(this.field_145850_b, this.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection)));
                        this.isFormed = true;
                    }
                }
                if (this.ticker > 6000) {
                    this.ticker = 0;
                }
            }
            if (this.isFormed && this.mbDirection != -1) {
                if (!this.field_145850_b.func_175640_z(this.func_174877_v())) {
                    this.machineTick();
                } else {
                    this.onIdleTick();
                }
            } else {
                this.isProcessing = false;
            }
        }
    }

    public void machineTick() {
        if (this.canProcess()) {
            if (this.currentProgress < this.currentDuration) {
                this.isProcessing = true;
                this.onProcessTick();
                ++this.currentProgress;
            } else {
                this.onProcessComplete();
                this.currentDuration = this.getCurrentProcessDuration();
                this.currentProgress = 0;
                this.isProcessing = false;
            }
        } else {
            this.isProcessing = false;
        }
    }

    public abstract int getBaseDuration();

    public abstract int getMinDuration();

    public abstract int getMaxDuration();

    public abstract float getSpeedMultiplier();

    public abstract boolean canProcess();

    public abstract void onProcessTick();

    public abstract void onProcessComplete();

    public int getCurrentProcessDuration() {
        int duration = (int)((float)this.getBaseDuration() * this.getSpeedMultiplier());
        if (duration < this.getMinDuration()) {
            return this.getMinDuration();
        }
        if (duration > this.getMaxDuration()) {
            return this.getMaxDuration();
        }
        return duration;
    }

    public abstract void onIdleTick();

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("processing", this.isProcessing);
        nbt.func_74768_a("curr_dur", this.currentDuration);
        nbt.func_74768_a("curr_prog", this.currentProgress);
        if (this.isFormed) {
            nbt.func_74757_a("isFormed", this.isFormed);
            nbt.func_74768_a("mbdir", this.mbDirection);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isProcessing = nbt.func_74767_n("processing");
        this.currentDuration = nbt.func_74762_e("curr_dur");
        this.currentProgress = nbt.func_74762_e("curr_prog");
        if (nbt.func_74764_b("isFormed")) {
            this.isFormed = nbt.func_74767_n("isFormed");
            this.mbDirection = nbt.func_74762_e("mbdir");
        }
    }

    public int getMBDirection() {
        return this.mbDirection;
    }

    public EnumFacing getMBDirectionE() {
        return EnumFacing.func_82600_a((int)this.mbDirection);
    }

    public abstract MultiBlockStructure getStructure();

    protected void ejectAll(IItemHandler inv) {
        for (EnumFacing dir : this.getItemEjectableSides()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())) continue;
            IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (inv.getStackInSlot(i) == null) continue;
                ItemStack lefover = ItemHandlerHelper.insertItem((IItemHandler)ih, (ItemStack)inv.extractItem(i, inv.getStackInSlot((int)i).field_77994_a, true), (boolean)false);
                if (lefover != null) {
                    inv.extractItem(i, inv.getStackInSlot((int)i).field_77994_a - lefover.field_77994_a, false);
                    continue;
                }
                inv.extractItem(i, inv.getStackInSlot((int)i).field_77994_a, false);
            }
        }
    }

    public boolean addNextBlock(EntityPlayer player) {
        return this.getStructure().placeNextBlock(this.field_145850_b, player, this.func_174877_v());
    }

    public void creativeBuildAll(EntityPlayer player) {
        this.getStructure().placeAllInWorld(this.field_145850_b, player, this.func_174877_v());
    }

    public void creativeDestroyAll(EntityPlayer player) {
        this.getStructure().pickupMultiBlock(this.field_145850_b, player, this.func_174877_v());
    }

    public EnumFacing[] getItemEjectableSides() {
        return EnumFacing.values();
    }

    @Override
    public boolean isSlave(BlockPos pos) {
        return this.getStructure().getSlavePositions(this.field_145850_b, this.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection)).contains(pos);
    }

    @Override
    public void notifyChange(ISlaveTile slave, BlockPos pos) {
        this.deformMultiblock();
    }

    @Override
    public void deformMultiblock() {
        for (BlockPos p : this.getStructure().getSlavePositions(this.field_145850_b, this.func_174877_v(), EnumFacing.func_82600_a((int)this.mbDirection))) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (te == null || !(te instanceof ISlaveTile)) continue;
            ((ISlaveTile)te).removeController();
        }
        this.isFormed = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void clientPacketUpdate(boolean formed, boolean isProcessing, int currentDuration, int currentProgress) {
        this.isFormed = formed;
        this.isProcessing = isProcessing;
        this.currentDuration = currentDuration;
        this.currentProgress = currentProgress;
    }

    @Override
    public boolean isFormed() {
        return this.isFormed;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public String getInformation(EntityPlayer player) {
        return "Direction: " + (this.mbDirection != -1 ? EnumFacing.func_82600_a((int)this.mbDirection).func_176610_l() : Integer.valueOf(this.mbDirection));
    }

    @Override
    public String getDebug() {
        return this.getInformation(null);
    }
}

