/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.gui.client.elements;

import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.audio.SoundHandler;

public abstract class VLElement {
    protected VLGuiContainer gui;
    protected final String elementAddress;
    protected boolean visible = true;
    protected int elementID;
    protected int left;
    protected int top;
    protected List<String> localizedTooltips;

    public VLElement(String elementAddress, VLGuiContainer gui) {
        this.gui = gui;
        this.elementAddress = elementAddress;
    }

    public VLElement(VLGuiContainer gui) {
        this.gui = gui;
        this.elementAddress = "unnamed";
    }

    public void setID(int id) {
        this.elementID = id;
    }

    public int getID() {
        return this.elementID;
    }

    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY, int left, int top) {
        if (this.visible) {
            this.drawBackgroundLayer(partialTicks, mouseX, mouseY, left, top);
        }
    }

    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        if (this.visible) {
            this.drawForegroundLayer(mouseX, mouseY);
        }
    }

    public boolean isMouseInBox(int mx, int my, int bx, int by, int bx2, int by2) {
        return mx >= bx && mx < bx2 && my >= by && my < by2;
    }

    protected abstract void drawBackgroundLayer(float var1, int var2, int var3, int var4, int var5);

    protected abstract void drawForegroundLayer(int var1, int var2);

    public abstract void updateScreen();

    public abstract boolean onMouseClick(int var1, int var2, int var3, int var4, int var5);

    public void playPressSound(SoundHandler soundHandlerIn) {
    }

    public void drawToolTip(int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.localizedTooltips != null && this.drawToolTipAt(mouseX, mouseY, guiLeft, guiTop)) {
            this.gui.drawHoveringText(this.localizedTooltips);
        }
    }

    public abstract boolean drawToolTipAt(int var1, int var2, int var3, int var4);

    public void addToolTip(String localizedToolTip) {
        if (this.localizedTooltips == null) {
            this.localizedTooltips = new ArrayList<String>();
        }
        this.localizedTooltips.add(localizedToolTip);
    }

    public void setToolTipList(List<String> tooltips) {
        this.localizedTooltips = tooltips;
    }
}

