/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.gui.client;

import com.valkyrieofnight.valkyrielib.client.SizableBox;
import com.valkyrieofnight.valkyrielib.client.TexUtils;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import com.valkyrieofnight.valkyrielib.gui.container.VLContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class VLGuiContainer
extends GuiContainer {
    protected static final int GUI_MIN_WIDTH = 128;
    protected static final int GUI_MIN_HEIGHT = 128;
    protected List<VLElement> elements = new ArrayList<VLElement>();
    private int elementID;
    protected int mouseX = 0;
    protected int mouseY = 0;
    private int guiWidth;
    private int guiHeight;
    private int left;
    private int top;
    private SizableBox guiBackground;
    private EntityPlayer player;

    public VLGuiContainer(EntityPlayer player, VLContainer inventorySlotsIn, int sizeX, int sizeY, SizableBox style) {
        super((Container)inventorySlotsIn);
        this.player = player;
        this.initElements();
        this.field_146999_f = sizeX;
        this.field_147000_g = sizeY;
        this.guiBackground = style;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.left = (this.field_146294_l - this.field_146999_f) / 2;
        this.top = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public void addElement(VLElement e) {
        if (e != null) {
            e.setID(this.elementID++);
            this.elements.add(e);
        }
    }

    public abstract void initElements();

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (VLElement ele : this.elements) {
            if (!ele.onMouseClick(this.field_147003_i, this.field_147009_r, mouseX, mouseY, mouseButton)) continue;
            ele.playPressSound(this.field_146297_k.func_147118_V());
            this.mouseClicked(ele);
        }
    }

    public abstract void mouseClicked(VLElement var1);

    public void func_73876_c() {
        super.func_73876_c();
        for (VLElement e : this.elements) {
            e.updateScreen();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.mouseX = mouseX - this.field_147003_i;
        this.mouseY = mouseY - this.field_147009_r;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TexUtils.renderSizableBox(this.guiBackground, this, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.drawPostBackgroundPreElements(partialTicks, mouseX, mouseY);
        for (VLElement ele : this.elements) {
            ele.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
    }

    protected void drawPostBackgroundPreElements(float partialTicks, int mouseX, int mouseY) {
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (VLElement ele : this.elements) {
            ele.drawGuiContainerForegroundLayer(mouseX, mouseY);
        }
        for (VLElement ele : this.elements) {
            ele.drawToolTip(mouseX, mouseY, this.field_147003_i, this.field_147009_r);
        }
    }

    public void drawTiledTexture(int x, int y, int w, int h) {
        int i = 0;
        int j = 0;
        int k = 0;
        int m = 0;
        for (i = 0; i < w; i += 16) {
            for (j = 0; j < h; j += 16) {
                m = Math.min(w - i, 16);
                k = Math.min(h - j, 16);
                this.func_73729_b(x + i, y + j, 0, 0, m, k);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void bindTexture(ResourceLocation loc) {
        this.field_146297_k.func_110434_K().func_110577_a(loc);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public RenderItem getItemRenderer() {
        return this.field_146296_j;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void drawHoveringText(List<String> list) {
        super.func_146283_a(list, this.mouseX, this.mouseY);
    }

    public void drawHoveringTextOffset(List<String> list) {
        super.func_146283_a(list, this.mouseX + this.field_147003_i, this.mouseY + this.field_147009_r);
    }
}

