/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.config.old.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.valkyrieofnight.valkyrielib.config.old.property.PropertyBase;
import java.util.ArrayList;
import java.util.List;

public class PropertyCompound
extends PropertyBase {
    protected List<PropertyBase> values = new ArrayList<PropertyBase>();
    protected boolean saveWithName = true;

    public PropertyCompound(String name) {
        super(name);
    }

    public PropertyCompound() {
        super("");
    }

    public void add(PropertyBase property) {
        if (property != null && !this.hasValue(property.getName())) {
            this.values.add(property);
        }
    }

    @Override
    protected boolean loadProperty(JsonObject jObj) {
        if (jObj.has(this.propertyName)) {
            JsonObject data = jObj.get(this.propertyName).getAsJsonObject();
            for (PropertyBase prop : this.values) {
                prop.loadPropertyFromJson(data);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void saveProperty(JsonObject jObj) {
        JsonObject data = new JsonObject();
        for (PropertyBase entry : this.values) {
            entry.savePropertyToJson(data);
        }
        jObj.add(this.propertyName, (JsonElement)data);
    }

    public boolean hasValue(String name) {
        for (PropertyBase propertyBase : this.values) {
            if (!name.equals(propertyBase.getName())) continue;
            return true;
        }
        return false;
    }
}

