/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.network;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.bdew.lib.BdLib$;
import net.bdew.lib.Misc$;
import net.bdew.lib.network.BaseMessage;
import net.bdew.lib.network.NetChannel$ClientHandler$;
import net.bdew.lib.network.NetChannel$ServerHandler$;
import net.bdew.lib.network.SerializedMessageCodec;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001-\u0011!BT3u\u0007\"\fgN\\3m\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0005\u00151\u0011a\u00017jE*\u0011q\u0001C\u0001\u0005E\u0012,wOC\u0001\n\u0003\rqW\r^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005!a.Y7f+\u0005)\u0002C\u0001\f\u001a\u001d\tiq#\u0003\u0002\u0019\u001d\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tAb\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015q\u0017-\\3!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011e\t\t\u0003E\u0001i\u0011A\u0001\u0005\u0006'y\u0001\r!\u0006\u0005\bK\u0001\u0001\r\u0011\"\u0001'\u0003!\u0019\u0007.\u00198oK2\u001cX#A\u0014\u0011\t!js&O\u0007\u0002S)\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#aB#ok6l\u0015\r\u001d\t\u0003a]j\u0011!\r\u0006\u0003eM\n!B]3mCVt7\r[3s\u0015\t!T'A\u0002g[2T!A\u000e\u0005\u0002\u001d5Lg.Z2sC\u001a$hm\u001c:hK&\u0011\u0001(\r\u0002\u0005'&$W\r\u0005\u0002;}5\t1H\u0003\u0002\u0004y)\u0011QhM\u0001\u0007G>lWn\u001c8\n\u0005}Z$A\u0005$N\u0019\u0016k'-\u001a3eK\u0012\u001c\u0005.\u00198oK2Dq!\u0011\u0001A\u0002\u0013\u0005!)\u0001\u0007dQ\u0006tg.\u001a7t?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011Q\u0002R\u0005\u0003\u000b:\u0011A!\u00168ji\"9q\tQA\u0001\u0002\u00049\u0013a\u0001=%c!1\u0011\n\u0001Q!\n\u001d\n\u0011b\u00195b]:,Gn\u001d\u0011\u0006\t-\u0003\u0001\u0001\u0014\u0002\b\u001b\u0016\u001c8/Y4f!\r\u0011SjT\u0005\u0003\u001d\n\u00111BQ1tK6+7o]1hK6\t\u0001aB\u0003R\u0001!\u0005!+A\u0007TKJ4XM\u001d%b]\u0012dWM\u001d\t\u0003\u001fN3Q\u0001\u0016\u0001\t\u0002U\u0013QbU3sm\u0016\u0014\b*\u00198eY\u0016\u00148CA*W!\r9f\fY\u0007\u00021*\u0011\u0011LW\u0001\bG\"\fgN\\3m\u0015\tYF,A\u0003oKR$\u0018PC\u0001^\u0003\tIw.\u0003\u0002`1\nY2+[7qY\u0016\u001c\u0005.\u00198oK2LeNY8v]\u0012D\u0015M\u001c3mKJ\u0004\"a\u0014&\t\u000b}\u0019F\u0011\u00012\u0015\u0003ICQ\u0001Z*\u0005\u0002\u0015\fAb\u00195b]:,GNU3bIB\"2a\u00114l\u0011\u001597\r1\u0001i\u0003\r\u0019G\u000f\u001f\t\u0003/&L!A\u001b-\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")An\u0019a\u0001A\u0006\u0019Qn]4\b\u000b9\u0004\u0001\u0012A8\u0002\u001b\rc\u0017.\u001a8u\u0011\u0006tG\r\\3s!\ty\u0005OB\u0003r\u0001!\u0005!OA\u0007DY&,g\u000e\u001e%b]\u0012dWM]\n\u0003aZCQa\b9\u0005\u0002Q$\u0012a\u001c\u0005\u0006IB$\tA\u001e\u000b\u0004\u0007^D\b\"B4v\u0001\u0004A\u0007\"\u00027v\u0001\u0004\u0001\u0007\"\u0002>\u0001\t\u0003Y\u0018\u0001B5oSR$\u0012a\u0011\u0005\b{\u0002\u0001\r\u0011\"\u0001\u007f\u0003-\u0019G.[3oi\u000eC\u0017-\u001b8\u0016\u0003}\u0004R!DA\u0001A\u000eK1!a\u0001\u000f\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\"CA\u0004\u0001\u0001\u0007I\u0011AA\u0005\u0003=\u0019G.[3oi\u000eC\u0017-\u001b8`I\u0015\fHcA\"\u0002\f!Aq)!\u0002\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0015B@\u0002\u0019\rd\u0017.\u001a8u\u0007\"\f\u0017N\u001c\u0011\t\u0013\u0005M\u0001\u00011A\u0005\u0002\u0005U\u0011aC:feZ,'o\u00115bS:,\"!a\u0006\u0011\r5\t\t!!\u0007D!\u0019i\u00111\u00041\u0002 %\u0019\u0011Q\u0004\b\u0003\rQ+\b\u000f\\33!\u0011\t\t#a\f\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\ta\u0001\u001d7bs\u0016\u0014(\u0002BA\u0015\u0003W\ta!\u001a8uSRL(bAA\u0017\u0011\u0005IQ.\u001b8fGJ\fg\r^\u0005\u0005\u0003c\t\u0019C\u0001\bF]RLG/\u001f)mCf,'/\u0014)\t\u0013\u0005U\u0002\u00011A\u0005\u0002\u0005]\u0012aD:feZ,'o\u00115bS:|F%Z9\u0015\u0007\r\u000bI\u0004C\u0005H\u0003g\t\t\u00111\u0001\u0002\u0018!A\u0011Q\b\u0001!B\u0013\t9\"\u0001\u0007tKJ4XM]\"iC&t\u0007\u0005C\u0004\u0002B\u0001!\t!a\u0011\u0002!I,wmU3sm\u0016\u0014\b*\u00198eY\u0016\u0014HcA\"\u0002F!A\u0011qIA \u0001\u0004\t9\"A\u0001g\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\n\u0001C]3h\u00072LWM\u001c;IC:$G.\u001a:\u0015\u0007\r\u000by\u0005C\u0004\u0002H\u0005%\u0003\u0019A@\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V\u0005Q\u0011\r\u001a3IC:$G.\u001a:\u0015\u000b\r\u000b9&a\u0017\t\u000f\u0005e\u0013\u0011\u000ba\u0001_\u0005!1/\u001b3f\u0011!\ti&!\u0015A\u0002\u0005}\u0013a\u00025b]\u0012dWM\u001d\t\u0004/\u0006\u0005\u0014bAA21\nq1\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\bbBA4\u0001\u0011\u0005\u0011\u0011N\u0001\ng\u0016tG\rV8BY2$2aQA6\u0011\u001d\ti'!\u001aA\u0002\u0001\fq!\\3tg\u0006<W\rC\u0004\u0002r\u0001!\t!a\u001d\u0002\rM,g\u000e\u001a+p)\u0015\u0019\u0015QOA<\u0011\u001d\ti'a\u001cA\u0002\u0001D\u0001\"!\n\u0002p\u0001\u0007\u0011q\u0004\u0005\b\u0003w\u0002A\u0011AA?\u0003=\u0019XM\u001c3U_\u0006cG.\u0011:pk:$G#B\"\u0002\u0000\u0005\u0005\u0005bBA7\u0003s\u0002\r\u0001\u0019\u0005\t\u0003\u0007\u000bI\b1\u0001\u0002\u0006\u0006)\u0001o\\5oiB!\u0011qQAG\u001d\rQ\u0014\u0011R\u0005\u0004\u0003\u0017[\u0014a\u0004(fi^|'o\u001b*fO&\u001cHO]=\n\t\u0005=\u0015\u0011\u0013\u0002\f)\u0006\u0014x-\u001a;Q_&tGOC\u0002\u0002\fnBq!!&\u0001\t\u0003\t9*A\btK:$Gk\u001c#j[\u0016t7/[8o)\u0015\u0019\u0015\u0011TAN\u0011\u001d\ti'a%A\u0002\u0001D\u0001\"!(\u0002\u0014\u0002\u0007\u0011qT\u0001\fI&lWM\\:j_:LE\rE\u0002\u000e\u0003CK1!a)\u000f\u0005\rIe\u000e\u001e\u0005\b\u0003O\u0003A\u0011AAU\u00031\u0019XM\u001c3U_N+'O^3s)\r\u0019\u00151\u0016\u0005\b\u0003[\n)\u000b1\u0001a\u0001")
public class NetChannel {
    private final String name;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private PartialFunction<BaseMessage<NetChannel>, BoxedUnit> clientChain;
    private PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> serverChain;
    private volatile NetChannel$ServerHandler$ ServerHandler$module;
    private volatile NetChannel$ClientHandler$ ClientHandler$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetChannel$ServerHandler$ ServerHandler$lzycompute() {
        NetChannel netChannel = this;
        synchronized (netChannel) {
            if (this.ServerHandler$module != null) return this.ServerHandler$module;
            this.ServerHandler$module = new NetChannel$ServerHandler$(this);
            return this.ServerHandler$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetChannel$ClientHandler$ ClientHandler$lzycompute() {
        NetChannel netChannel = this;
        synchronized (netChannel) {
            if (this.ClientHandler$module != null) return this.ClientHandler$module;
            this.ClientHandler$module = new NetChannel$ClientHandler$(this);
            return this.ClientHandler$module;
        }
    }

    public String name() {
        return this.name;
    }

    public EnumMap<Side, FMLEmbeddedChannel> channels() {
        return this.channels;
    }

    public void channels_$eq(EnumMap<Side, FMLEmbeddedChannel> x$1) {
        this.channels = x$1;
    }

    public NetChannel$ServerHandler$ ServerHandler() {
        return this.ServerHandler$module == null ? this.ServerHandler$lzycompute() : this.ServerHandler$module;
    }

    public NetChannel$ClientHandler$ ClientHandler() {
        return this.ClientHandler$module == null ? this.ClientHandler$lzycompute() : this.ClientHandler$module;
    }

    public void init() {
        if (this.channels() == null) {
            this.channels_$eq(NetworkRegistry.INSTANCE.newChannel(this.name(), new ChannelHandler[]{new SerializedMessageCodec()}));
            BdLib$.MODULE$.logInfo("Initialized network channel '%s' for mod '%s'", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), Misc$.MODULE$.getActiveModId()}));
            this.addHandler(Side.SERVER, (ChannelHandler)this.ServerHandler());
            this.addHandler(Side.CLIENT, (ChannelHandler)this.ClientHandler());
            return;
        }
        throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Attempted to initialize a channel twice (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
    }

    public PartialFunction<BaseMessage<NetChannel>, BoxedUnit> clientChain() {
        return this.clientChain;
    }

    public void clientChain_$eq(PartialFunction<BaseMessage<NetChannel>, BoxedUnit> x$1) {
        this.clientChain = x$1;
    }

    public PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> serverChain() {
        return this.serverChain;
    }

    public void serverChain_$eq(PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> x$1) {
        this.serverChain = x$1;
    }

    public void regServerHandler(PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> f) {
        this.serverChain_$eq((PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit>)this.serverChain().orElse(f));
    }

    public void regClientHandler(PartialFunction<BaseMessage<NetChannel>, BoxedUnit> f) {
        this.clientChain_$eq((PartialFunction<BaseMessage<NetChannel>, BoxedUnit>)this.clientChain().orElse(f));
    }

    private void addHandler(Side side, ChannelHandler handler) {
        FMLEmbeddedChannel ch = this.channels().get(side);
        String name = ch.findChannelHandlerNameForType(SerializedMessageCodec.class);
        ch.pipeline().addAfter(name, Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)side), "Handler"), handler);
    }

    public void sendToAll(BaseMessage<NetChannel> message) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(BaseMessage<NetChannel> message, EntityPlayerMP player) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(BaseMessage<NetChannel> message, NetworkRegistry.TargetPoint point) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(BaseMessage<NetChannel> message, int dimensionId) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(dimensionId));
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(BaseMessage<NetChannel> message) {
        ((DefaultAttributeMap)this.channels().get(Side.CLIENT)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        ((AbstractChannel)this.channels().get(Side.CLIENT)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public NetChannel(String name) {
        this.name = name;
        this.channels = null;
        this.clientChain = PartialFunction$.MODULE$.empty();
        this.serverChain = PartialFunction$.MODULE$.empty();
    }
}

