/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.modutils.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public final class BaublesUtils {
    public static final int AMULTER = 0;
    public static final int RING_1 = 1;
    public static final int RING_2 = 2;
    public static final int BELT = 3;
    public static final int HEAD = 4;
    public static final int BODY = 5;
    public static final int CHARM = 6;

    private BaublesUtils() {
        throw new IllegalAccessError("Utility class");
    }

    @Optional.Method(modid="Baubles")
    public static boolean hasItem(EntityPlayer player, Item item, int meta) {
        ItemStack stack;
        BaubleType type = BaublesUtils.getBaubleType(item, meta);
        if (type != null && (stack = BaublesUtils.getBauble(player, type)) != null) {
            return stack.func_77973_b().equals(item) && (meta < 0 || stack.func_77960_j() == meta);
        }
        return false;
    }

    @Optional.Method(modid="Baubles")
    public static List<ItemStack> getBaublesFromPlayer(EntityPlayer player, Item item, int meta) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot = 0; slot < BaubleType.TRINKET.getValidSlots().length; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack == null || stack.func_77973_b() != item || meta >= 0 && stack.func_77960_j() != meta) continue;
            items.add(stack);
        }
        return items;
    }

    @Optional.Method(modid="Baubles")
    public static BaubleType getBaubleType(Item item, int meta) {
        if (item instanceof IBauble) {
            return ((IBauble)item).getBaubleType(new ItemStack(item, meta));
        }
        return null;
    }

    @Optional.Method(modid="Baubles")
    public static ItemStack getBauble(EntityPlayer player, BaubleType type) {
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slotId : type.getValidSlots()) {
            ItemStack stack;
            if (inv == null || (stack = inv.getStackInSlot(slotId)) == null) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack getBauble(EntityPlayer player, int type) {
        ItemStack stack;
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (inv != null && (stack = inv.getStackInSlot(type)) != null) {
            return stack;
        }
        return null;
    }

    @Optional.Method(modid="Baubles")
    public static boolean hasBauble(EntityPlayer player, ItemStack stack, BaubleType type) {
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slotId : type.getValidSlots()) {
            if (inv == null || !ItemStackUtils.areStacksSimilar(stack, inv.getStackInSlot(slotId))) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="Baubles")
    public static boolean equipBauble(EntityPlayer player, ItemStack item, int slot) {
        ItemStack existing;
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        if (inv != null && (existing = inv.getStackInSlot(slot)) == null) {
            inv.setStackInSlot(slot, item.func_77946_l());
            --item.field_77994_a;
            return true;
        }
        return false;
    }
}

