/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import java.util.AbstractList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ModTrackingList<T>
extends AbstractList<T>
implements RandomAccess {
    private final List<T> delegate;
    private final Map<T, ModContainer> modContainerMap;

    public <D extends List<T> & RandomAccess> ModTrackingList(@Nonnull D delegate) {
        this(delegate, new IdentityHashMap());
    }

    public ModTrackingList(@Nonnull List<T> delegate, @Nonnull Map<T, ModContainer> modContainerMap) {
        this.delegate = delegate;
        this.modContainerMap = modContainerMap;
    }

    private void trackModContainer(@Nonnull T element) {
        this.trackModContainer(element, Loader.instance().activeModContainer());
    }

    private void trackModContainer(@Nonnull Collection<? extends T> elements) {
        ModContainer modContainer = Loader.instance().activeModContainer();
        for (T element : elements) {
            this.trackModContainer(element, modContainer);
        }
    }

    private void trackModContainer(@Nonnull T element, ModContainer container) {
        if (container != null && !container.getModId().equalsIgnoreCase("Forge")) {
            this.modContainerMap.put(element, container);
        }
    }

    public Map<T, ModContainer> getTrackedEntries() {
        return this.modContainerMap;
    }

    @Nullable
    public ModContainer getModContainer(@Nonnull T element) {
        return this.modContainerMap.get(element);
    }

    @Override
    public boolean add(@Nonnull T t) {
        boolean changed = this.delegate.add(t);
        if (changed) {
            this.trackModContainer(t);
        }
        return changed;
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public void add(int index, @Nonnull T element) {
        this.delegate.add(index, element);
        this.trackModContainer(element);
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends T> elements) {
        boolean changed = this.delegate.addAll(index, elements);
        if (changed) {
            this.trackModContainer(elements);
        }
        return changed;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends T> collection) {
        boolean changed = this.delegate.addAll(collection);
        if (changed) {
            this.trackModContainer(collection);
        }
        return changed;
    }

    @Override
    public T remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public boolean remove(@Nonnull Object object) {
        return this.delegate.remove(object);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public T set(int index, @Nonnull T element) {
        T previous = this.delegate.set(index, element);
        this.trackModContainer(element);
        return previous;
    }

    @Override
    @Nonnull
    public List<T> subList(int fromIndex, int toIndex) {
        List<T> delegateSubList = this.delegate.subList(fromIndex, toIndex);
        return new ModTrackingList<T>(delegateSubList, this.modContainerMap);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }
}

