/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.client.model.ITileEntityRender;
import net.darkhax.bookshelf.client.render.RenderBasicChest;
import net.darkhax.bookshelf.client.render.item.RenderFactoryItem;
import net.darkhax.bookshelf.common.ProxyCommon;
import net.darkhax.bookshelf.entity.FakeEntity;
import net.darkhax.bookshelf.features.Feature;
import net.darkhax.bookshelf.tileentity.TileEntityBasicChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ProxyClient
extends ProxyCommon {
    private static Map<Class<? extends TileEntity>, ITileEntityRender<?>> tileEntityRenderMap = new HashMap();

    @Override
    public void preInit() {
        for (Feature feature : Bookshelf.FEATURES) {
            feature.setupRendering();
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBasicChest.class, (TileEntitySpecialRenderer)new RenderBasicChest());
        RenderingRegistry.registerEntityRenderingHandler(FakeEntity.class, (IRenderFactory)new RenderFactoryItem());
    }

    public static void registerTileEntityRender(Class<? extends TileEntity> tileEntity, ITileEntityRender<?> iTileEntityRender) {
        tileEntityRenderMap.put(tileEntity, iTileEntityRender);
    }

    public static ITileEntityRender<TileEntity> getTileEntityRender(TileEntity tileEntity) {
        return ProxyClient.getTileEntityRender(tileEntity.getClass());
    }

    public static ITileEntityRender<TileEntity> getTileEntityRender(Class<? extends TileEntity> tileEntity) {
        return tileEntityRenderMap.get(tileEntity);
    }
}

