/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.managers.machine;

import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.inventory.ComparableItemStack;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalfoundation.block.BlockStorage;
import cofh.thermalfoundation.block.BlockStorageAlloy;
import cofh.thermalfoundation.item.ItemCoin;
import cofh.thermalfoundation.item.ItemMaterial;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CompactorManager {
    private static Map<ComparableItemStackCompactor, RecipeCompactor> recipeMapPress = new THashMap();
    private static Map<ComparableItemStackCompactor, RecipeCompactor> recipeMapStorage = new THashMap();
    private static Map<ComparableItemStackCompactor, RecipeCompactor> recipeMapMint = new THashMap();
    private static Set<ComparableItemStackCompactor> validationSet = new THashSet();
    static final int DEFAULT_ENERGY = 4000;
    static final int DEFAULT_ENERGY_STORAGE = 400;

    public static RecipeCompactor getRecipe(ItemStack input, Mode mode) {
        if (input == null) {
            return null;
        }
        ComparableItemStackCompactor query = new ComparableItemStackCompactor(input);
        RecipeCompactor recipe = null;
        switch (mode) {
            case PRESS: {
                recipe = recipeMapPress.get((Object)query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapPress.get((Object)query);
                break;
            }
            case STORAGE: {
                recipe = recipeMapStorage.get((Object)query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapStorage.get((Object)query);
                break;
            }
            case MINT: {
                recipe = recipeMapMint.get((Object)query);
                if (recipe != null) break;
                query.metadata = Short.MAX_VALUE;
                recipe = recipeMapMint.get((Object)query);
            }
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input, Mode mode) {
        return CompactorManager.getRecipe(input, mode) != null;
    }

    public static RecipeCompactor[] getRecipeList(Mode mode) {
        switch (mode) {
            case PRESS: {
                return recipeMapPress.values().toArray(new RecipeCompactor[recipeMapPress.size()]);
            }
            case STORAGE: {
                return recipeMapStorage.values().toArray(new RecipeCompactor[recipeMapStorage.size()]);
            }
        }
        return recipeMapMint.values().toArray(new RecipeCompactor[recipeMapMint.size()]);
    }

    public static boolean isItemValid(ItemStack input) {
        return input != null && validationSet.contains((Object)new ComparableItemStackCompactor(input));
    }

    public static void initialize() {
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotIron, ItemMaterial.plateIron);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotGold, ItemMaterial.plateGold);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotCopper, ItemMaterial.plateCopper);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotTin, ItemMaterial.plateTin);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotSilver, ItemMaterial.plateSilver);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotLead, ItemMaterial.plateLead);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotAluminum, ItemMaterial.plateAluminum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotNickel, ItemMaterial.plateNickel);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotPlatinum, ItemMaterial.platePlatinum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotIridium, ItemMaterial.plateIridium);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotMithril, ItemMaterial.plateMithril);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotSteel, ItemMaterial.plateSteel);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotElectrum, ItemMaterial.plateElectrum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotInvar, ItemMaterial.plateInvar);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotBronze, ItemMaterial.plateBronze);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotConstantan, ItemMaterial.plateConstantan);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotSignalum, ItemMaterial.plateSignalum);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotLumium, ItemMaterial.plateLumium);
        CompactorManager.addDefaultPressRecipe(ItemMaterial.ingotEnderium, ItemMaterial.plateEnderium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotCopper, BlockStorage.blockCopper);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotTin, BlockStorage.blockTin);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSilver, BlockStorage.blockSilver);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotLead, BlockStorage.blockLead);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotAluminum, BlockStorage.blockAluminum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotNickel, BlockStorage.blockNickel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotIridium, BlockStorage.blockIridium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotMithril, BlockStorage.blockMithril);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetDiamond, ItemMaterial.gemDiamond);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium);
        CompactorManager.addDefaultStorageRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetIron, ItemMaterial.ingotIron, new ItemStack(Blocks.field_150339_S), ItemCoin.coinIron);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetGold, ItemMaterial.ingotGold, new ItemStack(Blocks.field_150340_R), ItemCoin.coinGold);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetCopper, ItemMaterial.ingotCopper, BlockStorage.blockCopper, ItemCoin.coinCopper);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetTin, ItemMaterial.ingotTin, BlockStorage.blockTin, ItemCoin.coinTin);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetSilver, ItemMaterial.ingotSilver, BlockStorage.blockSilver, ItemCoin.coinSilver);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetLead, ItemMaterial.ingotLead, BlockStorage.blockLead, ItemCoin.coinLead);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetAluminum, ItemMaterial.ingotAluminum, BlockStorage.blockAluminum, ItemCoin.coinAluminum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetNickel, ItemMaterial.ingotNickel, BlockStorage.blockNickel, ItemCoin.coinNickel);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetPlatinum, ItemMaterial.ingotPlatinum, BlockStorage.blockPlatinum, ItemCoin.coinPlatinum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetIridium, ItemMaterial.ingotIridium, BlockStorage.blockIridium, ItemCoin.coinIridium);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetMithril, ItemMaterial.ingotMithril, BlockStorage.blockMithril, ItemCoin.coinMithril);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetSteel, ItemMaterial.ingotSteel, BlockStorageAlloy.blockSteel, ItemCoin.coinSteel);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetElectrum, ItemMaterial.ingotElectrum, BlockStorageAlloy.blockElectrum, ItemCoin.coinElectrum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetInvar, ItemMaterial.ingotInvar, BlockStorageAlloy.blockInvar, ItemCoin.coinInvar);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetBronze, ItemMaterial.ingotBronze, BlockStorageAlloy.blockBronze, ItemCoin.coinBronze);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetConstantan, ItemMaterial.ingotConstantan, BlockStorageAlloy.blockConstantan, ItemCoin.coinConstantan);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetSignalum, ItemMaterial.ingotSignalum, BlockStorageAlloy.blockSignalum, ItemCoin.coinSignalum);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetLumium, ItemMaterial.ingotLumium, BlockStorageAlloy.blockLumium, ItemCoin.coinLumium);
        CompactorManager.addDefaultMintRecipe(ItemMaterial.nuggetEnderium, ItemMaterial.ingotEnderium, BlockStorageAlloy.blockEnderium, ItemCoin.coinEnderium);
        CompactorManager.loadRecipes();
    }

    public static void loadRecipes() {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack compare;
            boolean match;
            ShapedRecipes target;
            if (recipe instanceof ShapedRecipes) {
                target = (ShapedRecipes)recipe;
                if (target.field_77574_d.length != 4 && target.field_77574_d.length != 9) continue;
                match = true;
                for (int i = 1; i < target.field_77574_d.length; ++i) {
                    match &= ItemHelper.itemsIdentical((ItemStack)target.field_77574_d[0], (ItemStack)target.field_77574_d[i]);
                }
                if (!match) continue;
                CompactorManager.addDefaultStorageRecipe(target.field_77574_d[0], target.func_77571_b(), target.field_77574_d.length);
                continue;
            }
            if (recipe instanceof ShapelessRecipes) {
                target = (ShapelessRecipes)recipe;
                if (target.func_77570_a() != 4 && target.func_77570_a() != 9) continue;
                match = true;
                for (int i = 1; i < target.func_77570_a(); ++i) {
                    match &= ItemHelper.itemsIdentical((ItemStack)((ItemStack)target.field_77579_b.get(0)), (ItemStack)((ItemStack)target.field_77579_b.get(i)));
                }
                if (!match) continue;
                CompactorManager.addDefaultStorageRecipe((ItemStack)target.field_77579_b.get(0), target.func_77571_b(), target.func_77570_a());
                continue;
            }
            if (recipe instanceof ShapedOreRecipe) {
                target = (ShapedOreRecipe)recipe;
                if (target.func_77570_a() != 4 && target.func_77570_a() != 9) continue;
                match = true;
                if (target.getInput()[0] instanceof List && !((List)target.getInput()[0]).isEmpty()) {
                    ItemStack input = (ItemStack)((List)target.getInput()[0]).get(0);
                    for (int i = 1; i < target.func_77570_a(); ++i) {
                        if (target.getInput()[i] instanceof List && !((List)target.getInput()[i]).isEmpty()) {
                            compare = (ItemStack)((List)target.getInput()[i]).get(0);
                            match &= ItemHelper.itemsIdentical((ItemStack)input, (ItemStack)compare);
                            continue;
                        }
                        match = false;
                    }
                    if (!match) continue;
                    List ores = (List)target.getInput()[0];
                    for (ItemStack ore : ores) {
                        CompactorManager.addDefaultStorageRecipe(ore, target.func_77571_b(), target.func_77570_a());
                    }
                    continue;
                }
                if (!(target.getInput()[0] instanceof ItemStack)) continue;
                ItemStack input = (ItemStack)target.getInput()[0];
                for (int i = 1; i < target.func_77570_a(); ++i) {
                    if (target.getInput()[i] instanceof ItemStack) {
                        match &= ItemHelper.itemsIdentical((ItemStack)input, (ItemStack)((ItemStack)target.getInput()[i]));
                        continue;
                    }
                    match = false;
                }
                if (!match) continue;
                CompactorManager.addDefaultStorageRecipe((ItemStack)target.getInput()[0], target.func_77571_b(), target.func_77570_a());
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipe) || (target = (ShapelessOreRecipe)recipe).func_77570_a() != 4 && target.func_77570_a() != 9) continue;
            match = true;
            if (target.getInput().get(0) instanceof List && !((List)target.getInput().get(0)).isEmpty()) {
                ItemStack input = (ItemStack)((List)target.getInput().get(0)).get(0);
                for (int i = 1; i < target.func_77570_a(); ++i) {
                    if (target.getInput().get(i) instanceof List && !((List)target.getInput().get(i)).isEmpty()) {
                        compare = (ItemStack)((List)target.getInput().get(i)).get(0);
                        match &= ItemHelper.itemsIdentical((ItemStack)input, (ItemStack)compare);
                        continue;
                    }
                    match = false;
                }
                if (!match) continue;
                List ores = (List)target.getInput().get(0);
                for (ItemStack ore : ores) {
                    CompactorManager.addDefaultStorageRecipe(ore, target.func_77571_b(), target.func_77570_a());
                }
                continue;
            }
            if (!(target.getInput().get(0) instanceof ItemStack)) continue;
            ItemStack input = (ItemStack)target.getInput().get(0);
            for (int i = 1; i < target.func_77570_a(); ++i) {
                if (target.getInput().get(i) instanceof ItemStack) {
                    match &= ItemHelper.itemsIdentical((ItemStack)input, (ItemStack)((ItemStack)target.getInput().get(i)));
                    continue;
                }
                match = false;
            }
            if (!match) continue;
            CompactorManager.addDefaultStorageRecipe((ItemStack)target.getInput().get(0), target.func_77571_b(), target.func_77570_a());
        }
    }

    public static void refresh() {
        ComparableItemStackCompactor input;
        RecipeCompactor tempRecipe;
        THashMap tempPress = new THashMap(recipeMapPress.size());
        THashMap tempStorage = new THashMap(recipeMapStorage.size());
        THashMap tempMint = new THashMap(recipeMapMint.size());
        THashSet tempSet = new THashSet();
        for (Map.Entry<ComparableItemStackCompactor, RecipeCompactor> entry : recipeMapPress.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackCompactor(tempRecipe.input);
            tempPress.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackCompactor, RecipeCompactor> entry : recipeMapStorage.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackCompactor(tempRecipe.input);
            tempStorage.put(input, tempRecipe);
            tempSet.add(input);
        }
        for (Map.Entry<ComparableItemStackCompactor, RecipeCompactor> entry : recipeMapMint.entrySet()) {
            tempRecipe = entry.getValue();
            input = new ComparableItemStackCompactor(tempRecipe.input);
            tempMint.put(input, tempRecipe);
            tempSet.add(input);
        }
        recipeMapPress.clear();
        recipeMapStorage.clear();
        recipeMapMint.clear();
        recipeMapPress = tempPress;
        recipeMapStorage = tempStorage;
        recipeMapMint = tempMint;
        validationSet.clear();
        validationSet = tempSet;
    }

    public static RecipeCompactor addRecipe(int energy, ItemStack input, ItemStack output, Mode mode) {
        if (input == null || output == null || energy <= 0 || CompactorManager.recipeExists(input, mode)) {
            return null;
        }
        RecipeCompactor recipe = new RecipeCompactor(input, output, energy);
        switch (mode) {
            case PRESS: {
                recipeMapPress.put(new ComparableItemStackCompactor(input), recipe);
                break;
            }
            case STORAGE: {
                recipeMapStorage.put(new ComparableItemStackCompactor(input), recipe);
                break;
            }
            case MINT: {
                recipeMapMint.put(new ComparableItemStackCompactor(input), recipe);
            }
        }
        validationSet.add(new ComparableItemStackCompactor(input));
        return recipe;
    }

    public static RecipeCompactor removeRecipe(ItemStack input, Mode mode) {
        switch (mode) {
            case PRESS: {
                return recipeMapPress.remove((Object)new ComparableItemStackCompactor(input));
            }
            case STORAGE: {
                return recipeMapStorage.remove((Object)new ComparableItemStackCompactor(input));
            }
        }
        return recipeMapMint.remove((Object)new ComparableItemStackCompactor(input));
    }

    private static void addDefaultPressRecipe(ItemStack input, ItemStack output) {
        CompactorManager.addRecipe(4000, input, output, Mode.PRESS);
    }

    private static void addDefaultStorageRecipe(ItemStack input, ItemStack output) {
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)9);
        if (!CompactorManager.recipeExists(inputStack, Mode.STORAGE)) {
            CompactorManager.addRecipe(400, inputStack, output, Mode.STORAGE);
        }
    }

    private static void addDefaultStorageRecipe(ItemStack input, ItemStack output, int count) {
        ItemStack inputStack = ItemHelper.cloneStack((ItemStack)input, (int)count);
        if (!CompactorManager.recipeExists(inputStack, Mode.STORAGE)) {
            CompactorManager.addRecipe(400, inputStack, output, Mode.STORAGE);
        }
    }

    private static void addDefaultMintRecipe(ItemStack nugget, ItemStack ingot, ItemStack block, ItemStack output) {
        CompactorManager.addRecipe(1000, ItemHelper.cloneStack((ItemStack)nugget, (int)3), ItemHelper.cloneStack((ItemStack)output, (int)1), Mode.MINT);
        CompactorManager.addRecipe(4000, ItemHelper.cloneStack((ItemStack)ingot, (int)1), ItemHelper.cloneStack((ItemStack)output, (int)3), Mode.MINT);
        CompactorManager.addRecipe(32000, ItemHelper.cloneStack((ItemStack)block, (int)1), ItemHelper.cloneStack((ItemStack)output, (int)27), Mode.MINT);
    }

    public static class ComparableItemStackCompactor
    extends ComparableItemStack {
        public static final String NUGGET = "nugget";
        public static final String INGOT = "ingot";
        public static final String BLOCK = "block";
        public static final String DUST = "dust";

        public static boolean safeOreType(String oreName) {
            return oreName.startsWith(NUGGET) || oreName.startsWith(INGOT) || oreName.startsWith(BLOCK) || oreName.startsWith(DUST);
        }

        public static int getOreID(ItemStack stack) {
            ArrayList ids = OreDictionaryArbiter.getAllOreIDs((ItemStack)stack);
            if (ids != null) {
                int i = 0;
                int e = ids.size();
                while (i < e) {
                    int id;
                    if ((id = ((Integer)ids.get(i++)).intValue()) == -1 || !ComparableItemStackCompactor.safeOreType(ItemHelper.oreProxy.getOreName(id))) continue;
                    return id;
                }
            }
            return -1;
        }

        public ComparableItemStackCompactor(ItemStack stack) {
            super(stack);
            this.oreID = ComparableItemStackCompactor.getOreID(stack);
        }

        public ComparableItemStackCompactor set(ItemStack stack) {
            super.set(stack);
            this.oreID = ComparableItemStackCompactor.getOreID(stack);
            return this;
        }
    }

    public static enum Mode {
        PRESS,
        STORAGE,
        MINT;

    }

    public static class RecipeCompactor {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        RecipeCompactor(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
            if (input.field_77994_a <= 0) {
                input.field_77994_a = 1;
            }
            if (output.field_77994_a <= 0) {
                output.field_77994_a = 1;
            }
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

