/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.fuels.reactant;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoReactant;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.fuels.BaseFuelCategory;
import cofh.thermalexpansion.plugins.jei.fuels.reactant.ReactantFuelHandler;
import cofh.thermalexpansion.plugins.jei.fuels.reactant.ReactantFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ReactantFuelCategory
extends BaseFuelCategory<ReactantFuelWrapper> {
    public static boolean enable = true;
    IDrawableStatic tank;
    IDrawableStatic tankOverlayInput;

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new ReactantFuelCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ReactantFuelHandler()});
        registry.addRecipes(ReactantFuelCategory.getRecipes(guiHelper));
        registry.addRecipeClickArea(GuiDynamoReactant.class, 115, 35, 16, 16, new String[]{"thermalexpansion.reactant"});
        registry.addRecipeCategoryCraftingItem(BlockDynamo.dynamoReactant, new String[]{"thermalexpansion.reactant"});
    }

    public static List<ReactantFuelWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<ReactantFuelWrapper> recipes = new ArrayList<ReactantFuelWrapper>();
        for (ReactantManager.Reaction reaction : ReactantManager.getReactionList()) {
            recipes.add(new ReactantFuelWrapper(guiHelper, reaction));
        }
        return recipes;
    }

    public ReactantFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiDynamoReactant.TEXTURE, 26, 11, 70, 62, 0, 0, 16, 78);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(5);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.dynamo.reactant.name");
        this.tank = Drawables.getDrawables(guiHelper).getTank(2);
        this.tankOverlayInput = Drawables.getDrawables(guiHelper).getTankSmallOverlay(2);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.reactant";
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.energyMeter.draw(minecraft, 71, 7);
        this.durationEmpty.draw(minecraft, 22, 43);
        this.tank.draw(minecraft, 9, 9);
    }

    public void setRecipe(IRecipeLayout recipeLayout, ReactantFuelWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List inputFluids = ingredients.getInputs(FluidStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 33, 23);
        guiFluidStacks.init(0, true, 10, 10, 16, 30, 1000, false, (IDrawable)this.tankOverlayInput);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
    }
}

