/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.insolator;

import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.TileInsolator;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.JEIPluginTE;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class InsolatorRecipeWrapper
extends BaseRecipeWrapper {
    final List<List<ItemStack>> inputs;
    final List<List<FluidStack>> inputFluids;
    final List<ItemStack> outputs;
    final int chance;
    final InsolatorManager.Type substrate;
    final IDrawableAnimated fluid;
    final IDrawableAnimated progress;
    final IDrawableAnimated speed;

    public InsolatorRecipeWrapper(IGuiHelper guiHelper, InsolatorManager.RecipeInsolator recipe) {
        this(guiHelper, recipe, "thermalexpansion.insolator");
    }

    public InsolatorRecipeWrapper(IGuiHelper guiHelper, InsolatorManager.RecipeInsolator recipe, String uIdIn) {
        this.uId = uIdIn;
        ArrayList<List<ItemStack>> recipeInputs = new ArrayList<List<ItemStack>>();
        ArrayList<FluidStack> recipeInputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> recipeInputsPrimary = new ArrayList<ItemStack>();
        ArrayList<ItemStack> recipeInputsSecondary = new ArrayList<ItemStack>();
        int oreID = InsolatorManager.ComparableItemStackInsolator.getOreID(recipe.getPrimaryInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputsPrimary.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getPrimaryInput().field_77994_a));
            }
        } else {
            recipeInputsPrimary.add(recipe.getPrimaryInput());
        }
        oreID = InsolatorManager.ComparableItemStackInsolator.getOreID(recipe.getSecondaryInput());
        if (oreID != -1) {
            for (ItemStack ore : OreDictionary.getOres((String)ItemHelper.oreProxy.getOreName(oreID), (boolean)false)) {
                recipeInputsSecondary.add(ItemHelper.cloneStack((ItemStack)ore, (int)recipe.getSecondaryInput().field_77994_a));
            }
        } else {
            recipeInputsSecondary.add(recipe.getSecondaryInput());
        }
        recipeInputs.add(recipeInputsPrimary);
        recipeInputs.add(recipeInputsSecondary);
        recipeInputFluids.add(new FluidStack(FluidRegistry.WATER, recipe.getEnergy() / 10));
        ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
        recipeOutputs.add(recipe.getPrimaryOutput());
        if (recipe.getSecondaryOutput() != null) {
            recipeOutputs.add(recipe.getSecondaryOutput());
        }
        this.inputs = recipeInputs;
        this.inputFluids = Collections.singletonList(recipeInputFluids);
        this.outputs = recipeOutputs;
        this.energy = recipe.getEnergy();
        this.chance = recipe.getSecondaryOutputChance();
        this.substrate = recipe.getType();
        IDrawableStatic fluidDrawable = Drawables.getDrawables(guiHelper).getProgress(1);
        IDrawableStatic progressDrawable = Drawables.getDrawables(guiHelper).getProgressFill(1);
        IDrawableStatic speedDrawable = Drawables.getDrawables(guiHelper).getScaleFill(8);
        IDrawableStatic energyDrawable = Drawables.getDrawables(guiHelper).getEnergyFill();
        this.fluid = guiHelper.createAnimatedDrawable(fluidDrawable, this.energy / TileInsolator.basePower, IDrawableAnimated.StartDirection.LEFT, true);
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, this.energy / TileInsolator.basePower, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(speedDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
        this.energyMeter = guiHelper.createAnimatedDrawable(energyDrawable, 1000, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setInputLists(FluidStack.class, this.inputFluids);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        JEIPluginTE.drawFluid(69, 23, this.inputFluids.get(0).get(0), 24, 16);
        this.fluid.draw(minecraft, 69, 23);
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 34);
        this.energyMeter.draw(minecraft, 2, 8);
        if (this.chance > 0) {
            String dispChance = StringHelper.formatNumber((long)this.chance) + "%";
            minecraft.field_71466_p.func_78276_b(dispChance, 102 - 6 * dispChance.length(), 48, 0x808080);
        }
    }
}

