/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.TapperManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TConstructPlugin {
    public static final String MOD_ID = "tconstruct";
    public static final String MOD_NAME = "Tinkers' Construct";
    private static final String NUGGET = "nugget";
    private static final String INGOT = "ingot";
    private static final String ORE = "ore";
    private static final String BLOCK = "block";
    private static final String DUST = "dust";
    private static final String PLATE = "plate";

    private TConstructPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Tinkers' Construct is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ItemStack slimeCongealed = TConstructPlugin.getBlockStack("slime_congealed", 1, 0);
            ItemStack slimeCongealedMagma = TConstructPlugin.getBlockStack("slime_congealed", 1, 4);
            ItemStack saplingSlimeBlue = TConstructPlugin.getItem("slime_sapling", 1, 0);
            ItemStack saplingSlimePurple = TConstructPlugin.getItem("slime_sapling", 1, 1);
            ItemStack saplingSlimeMagma = TConstructPlugin.getItem("slime_sapling", 1, 2);
            Block log = TConstructPlugin.getBlock("slime_congealed");
            Block leaves = TConstructPlugin.getBlock("slime_leaves");
            Fluid blueslime = FluidRegistry.getFluid((String)"blueslime");
            Fluid emerald = FluidRegistry.getFluid((String)"emerald");
            TConstructPlugin.addRecipeSet("iron");
            TConstructPlugin.addRecipeSet("gold");
            if (emerald != null) {
                CrucibleManager.addRecipe(4000, new ItemStack(Items.field_151166_bC), new FluidStack(emerald, 666));
                CrucibleManager.addRecipe(8000, new ItemStack(Blocks.field_150412_bA), new FluidStack(emerald, 1332));
                CrucibleManager.addRecipe(32000, new ItemStack(Blocks.field_150475_bE), new FluidStack(emerald, 5994));
            }
            TConstructPlugin.addRecipeSet("copper");
            TConstructPlugin.addRecipeSet("tin");
            TConstructPlugin.addRecipeSet("silver");
            TConstructPlugin.addRecipeSet("lead");
            TConstructPlugin.addRecipeSet("aluminum");
            TConstructPlugin.addRecipeSet("nickel");
            TConstructPlugin.addRecipeSet("platinum");
            TConstructPlugin.addRecipeSet("iridium");
            TConstructPlugin.addRecipeSet("steel");
            TConstructPlugin.addRecipeSet("electrum");
            TConstructPlugin.addRecipeSet("invar");
            TConstructPlugin.addRecipeSet("bronze");
            TConstructPlugin.addRecipeSet("constantan");
            TConstructPlugin.addRecipeSet("signalum");
            TConstructPlugin.addRecipeSet("lumium");
            TConstructPlugin.addRecipeSet("enderium");
            TConstructPlugin.addRecipeSet("ardite");
            TConstructPlugin.addRecipeSet("cobalt");
            TConstructPlugin.addRecipeSet("manyullyn");
            InsolatorManager.addDefaultTreeRecipe(saplingSlimeBlue, ItemHelper.cloneStack((ItemStack)slimeCongealed, (int)4), saplingSlimeBlue, 50, false, InsolatorManager.Type.MYCELIUM_TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingSlimePurple, ItemHelper.cloneStack((ItemStack)slimeCongealed, (int)4), saplingSlimePurple, 50, false, InsolatorManager.Type.MYCELIUM_TREE);
            InsolatorManager.addDefaultTreeRecipe(saplingSlimeMagma, ItemHelper.cloneStack((ItemStack)slimeCongealedMagma, (int)4), saplingSlimeMagma, 50, false, InsolatorManager.Type.MYCELIUM_TREE);
            TapperManager.addMapping(slimeCongealed, new FluidStack(blueslime, 25));
            TapperManager.addMapping(slimeCongealedMagma, new FluidStack(blueslime, 25));
            TConstructPlugin.addLeafMapping(log, 0, leaves, 0);
            TConstructPlugin.addLeafMapping(log, 0, leaves, 1);
            TConstructPlugin.addLeafMapping(log, 4, leaves, 2);
            ThermalExpansion.LOG.info("Thermal Expansion: Tinkers' Construct Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Tinkers' Construct Plugin encountered an error:", t);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("tconstruct:" + name));
        return block != null ? new ItemStack(block, amount, meta) : null;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return TConstructPlugin.getBlockStack(name, amount, 0);
    }

    private static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("tconstruct:" + name));
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tconstruct:" + name));
        return item != null ? new ItemStack(item, amount, meta) : null;
    }

    private static ItemStack getItem(String name) {
        return TConstructPlugin.getItem(name, 1, 0);
    }

    private static void addLeafMapping(Block logBlock, int logMeta, Block leafBlock, int leafMeta) {
        IBlockState logState = logBlock.func_176203_a(logMeta);
        for (Boolean check_decay : BlockLeaves.field_176236_b.func_177700_c()) {
            IBlockState leafState = leafBlock.func_176203_a(leafMeta).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.TRUE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)check_decay);
            TapperManager.addLeafMappingDirect(logState, leafState);
        }
    }

    private static boolean addRecipeSet(String oreType) {
        if (oreType == null || oreType.isEmpty()) {
            return false;
        }
        Fluid fluid = FluidRegistry.getFluid((String)oreType.toLowerCase(Locale.ENGLISH));
        if (fluid == null) {
            return false;
        }
        oreType = StringHelper.titleCase((String)oreType);
        int energy = 4000;
        int fluidIngot = 144;
        String nuggetName = NUGGET + oreType;
        String ingotName = INGOT + oreType;
        String oreName = ORE + oreType;
        String blockName = BLOCK + oreType;
        String dustName = DUST + oreType;
        String plateName = PLATE + oreType;
        ItemStack nugget = ItemHelper.getOre((String)nuggetName);
        ItemStack ingot = ItemHelper.getOre((String)ingotName);
        ItemStack ore = ItemHelper.getOre((String)oreName);
        ItemStack block = ItemHelper.getOre((String)blockName);
        ItemStack dust = ItemHelper.getOre((String)dustName);
        ItemStack plate = ItemHelper.getOre((String)plateName);
        if (nugget != null) {
            CrucibleManager.addRecipe(energy / 8, nugget, new FluidStack(fluid, fluidIngot / 9));
        }
        if (ingot != null) {
            CrucibleManager.addRecipe(energy, ingot, new FluidStack(fluid, fluidIngot));
        }
        if (ore != null) {
            CrucibleManager.addRecipe(energy * 2, ore, new FluidStack(fluid, fluidIngot * 2));
        }
        if (block != null) {
            CrucibleManager.addRecipe(energy * 8, block, new FluidStack(fluid, fluidIngot * 9));
        }
        if (dust != null) {
            CrucibleManager.addRecipe(energy / 2, dust, new FluidStack(fluid, fluidIngot));
        }
        if (plate != null) {
            CrucibleManager.addRecipe(energy, plate, new FluidStack(fluid, fluidIngot));
        }
        return true;
    }
}

