/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ForestryPlugin {
    public static final String MOD_ID = "forestry";
    public static final String MOD_NAME = "Forestry";

    private ForestryPlugin() {
    }

    public static void initialize() {
        String category = "Plugins";
        String comment = "If TRUE, support for Forestry is enabled.";
        boolean enable = ThermalExpansion.CONFIG.getConfiguration().getBoolean(MOD_NAME, category, true, comment);
        if (!enable || !Loader.isModLoaded((String)MOD_ID)) {
            return;
        }
        try {
            ItemStack woodPile = ForestryPlugin.getBlockStack("wood_pile", 1);
            ItemStack honeydew = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:honeydew"))), (int)1);
            ItemStack honeyDrop = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:honeyDrop"))), (int)1);
            ItemStack propolis = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:propolis"))), (int)1);
            ItemStack mulch = ItemHelper.cloneStack((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:mulch"))), (int)1);
            Fluid biomass = FluidRegistry.getFluid((String)"biomass");
            Fluid ethanol = FluidRegistry.getFluid((String)"bio.ethanol");
            Fluid honey = FluidRegistry.getFluid((String)"for.honey");
            Fluid juice = FluidRegistry.getFluid((String)"juice");
            Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
            FurnaceManager.addRecipePyrolysis(8000, woodPile, new ItemStack(Items.field_151044_h, 6, 1), 400);
            if (biomass != null && ethanol != null) {
                RefineryManager.addRecipe(3000, new FluidStack(biomass, 100), new FluidStack(ethanol, 30), null);
            }
            int energy = 4800;
            if (honey != null) {
                TransposerManager.addExtractRecipe(energy, honeydew, null, new FluidStack(honey, 100), 0, false);
                TransposerManager.addExtractRecipe(energy, honeyDrop, propolis, new FluidStack(honey, 100), 5, false);
            }
            energy = 2400;
            if (juice != null) {
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151034_e, (int)1), mulch, new FluidStack(juice, 200), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropDate"), (int)1), mulch, new FluidStack(juice, 50), 20, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropLemon"), (int)1), mulch, new FluidStack(juice, 400), 10, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPapaya"), (int)1), mulch, new FluidStack(juice, 600), 10, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropPlum"), (int)1), mulch, new FluidStack(juice, 100), 60, false);
            }
            if (seed_oil != null) {
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151014_N, (int)1), null, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151080_bb, (int)1), null, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((Item)Items.field_151081_bc, (int)1), null, new FluidStack(seed_oil, 10), 0, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropCherry"), (int)1), mulch, new FluidStack(seed_oil, 50), 5, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropChestnut"), (int)1), mulch, new FluidStack(seed_oil, 220), 2, false);
                TransposerManager.addExtractRecipe(energy, ItemHelper.cloneStack((ItemStack)ItemHelper.getOre((String)"cropWalnut"), (int)1), mulch, new FluidStack(seed_oil, 180), 5, false);
            }
            ThermalExpansion.LOG.info("Thermal Expansion: Forestry Plugin Enabled.");
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Forestry Plugin encountered an error:", t);
        }
    }

    public static void postInit() {
        try {
            ForestryPlugin.addSeedOilRecipes();
        }
        catch (Throwable t) {
            ThermalExpansion.LOG.error("Thermal Expansion: Forestry Plugin encountered an error:", t);
        }
    }

    public static void addSeedOilRecipes() {
        String[] oreNameList;
        Fluid seed_oil = FluidRegistry.getFluid((String)"seed.oil");
        if (seed_oil == null) {
            return;
        }
        for (String name : oreNameList = OreDictionary.getOreNames()) {
            List seed;
            if (!name.startsWith("seed") || (seed = OreDictionary.getOres((String)name, (boolean)false)).isEmpty()) continue;
            TransposerManager.addExtractRecipe(2400, ItemHelper.cloneStack((ItemStack)((ItemStack)seed.get(0)), (int)1), null, new FluidStack(seed_oil, 10), 0, false);
        }
    }

    private static ItemStack getBlockStack(String name, int amount, int meta) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("forestry:" + name));
        return block != null ? new ItemStack(block, amount, meta) : null;
    }

    private static ItemStack getBlockStack(String name, int amount) {
        return ForestryPlugin.getBlockStack(name, amount, 0);
    }

    private static ItemStack getItem(String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry:" + name));
        return item != null ? new ItemStack(item, amount, meta) : null;
    }

    private static ItemStack getItem(String name) {
        return ForestryPlugin.getItem(name, 1, 0);
    }
}

