/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.network;

import cofh.api.core.ISecurable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.util.tileentity.IRedstoneControl;
import cofh.core.util.tileentity.ITransferControl;
import cofh.lib.gui.container.IAugmentableContainer;
import cofh.thermalexpansion.ThermalExpansion;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketTEBase
extends PacketCoFHBase {
    public static void initialize() {
        PacketHandler.instance.registerPacket(PacketTEBase.class);
    }

    public void handlePacket(EntityPlayer player, boolean isServer) {
        try {
            byte type = this.getByte();
            switch (PacketTypes.values()[type]) {
                case RS_POWER_UPDATE: {
                    TileEntity tile;
                    BlockPos pos = this.getCoords();
                    if (player.field_70170_p.func_175667_e(pos) && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IRedstoneControl) {
                        IRedstoneControl rs = (IRedstoneControl)tile;
                        rs.setPowered(this.getBool());
                    }
                    return;
                }
                case RS_CONFIG_UPDATE: {
                    TileEntity tile;
                    BlockPos pos = this.getCoords();
                    if (player.field_70170_p.func_175667_e(pos) && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IRedstoneControl) {
                        IRedstoneControl rs = (IRedstoneControl)tile;
                        rs.setControl(IRedstoneControl.ControlMode.values()[this.getByte()]);
                    }
                    return;
                }
                case TRANSFER_UPDATE: {
                    TileEntity tile;
                    BlockPos pos = this.getCoords();
                    if (player.field_70170_p.func_175667_e(pos) && (tile = player.field_70170_p.func_175625_s(pos)) instanceof ITransferControl) {
                        ITransferControl transfer = (ITransferControl)tile;
                        transfer.setTransferIn(this.getBool());
                        transfer.setTransferOut(this.getBool());
                    }
                    return;
                }
                case SECURITY_UPDATE: {
                    if (player.field_71070_bA instanceof ISecurable) {
                        ((ISecurable)player.field_71070_bA).setAccess(ISecurable.AccessMode.values()[this.getByte()]);
                    }
                    return;
                }
                case TAB_AUGMENT: {
                    if (player.field_71070_bA instanceof IAugmentableContainer) {
                        ((IAugmentableContainer)player.field_71070_bA).setAugmentLock(this.getBool());
                    }
                    return;
                }
            }
            ThermalExpansion.LOG.error("Unknown Packet! Internal: TEPH, ID: " + type);
        }
        catch (Exception e) {
            ThermalExpansion.LOG.error("Packet payload failure! Please check your config files!");
            e.printStackTrace();
        }
    }

    public static void sendRSPowerUpdatePacketToClients(IRedstoneControl rs, World world, BlockPos pos) {
        PacketTEBase.sendRSPowerUpdatePacketToClients(rs, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static void sendRSPowerUpdatePacketToClients(IRedstoneControl rs, World world, int x, int y, int z) {
        PacketHandler.sendToAllAround((PacketBase)PacketTEBase.getPacket(PacketTypes.RS_POWER_UPDATE).addCoords(x, y, z).addBool(rs.isPowered()), (World)world, (int)x, (int)y, (int)z);
    }

    public static void sendRSConfigUpdatePacketToServer(IRedstoneControl rs, BlockPos pos) {
        PacketTEBase.sendRSConfigUpdatePacketToServer(rs, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static void sendRSConfigUpdatePacketToServer(IRedstoneControl rs, int x, int y, int z) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.RS_CONFIG_UPDATE).addCoords(x, y, z).addByte(rs.getControl().ordinal()));
    }

    public static void sendTransferUpdatePacketToServer(ITransferControl transfer, BlockPos pos) {
        PacketTEBase.sendTransferUpdatePacketToServer(transfer, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static void sendTransferUpdatePacketToServer(ITransferControl transfer, int x, int y, int z) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TRANSFER_UPDATE).addCoords(x, y, z).addBool(transfer.getTransferIn()).addBool(transfer.getTransferOut()));
    }

    public static void sendSecurityPacketToServer(ISecurable securable) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.SECURITY_UPDATE).addByte(securable.getAccess().ordinal()));
    }

    public static void sendTabAugmentPacketToServer(boolean lock) {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TAB_AUGMENT).addBool(lock));
    }

    public static void sendTabSchematicPacketToServer() {
        PacketHandler.sendToServer((PacketBase)PacketTEBase.getPacket(PacketTypes.TAB_SCHEMATIC));
    }

    public static PacketCoFHBase getPacket(PacketTypes theType) {
        return new PacketTEBase().addByte(theType.ordinal());
    }

    public static enum PacketTypes {
        RS_POWER_UPDATE,
        RS_CONFIG_UPDATE,
        TRANSFER_UPDATE,
        SECURITY_UPDATE,
        TAB_AUGMENT,
        TAB_SCHEMATIC,
        CONFIG_SYNC;

    }
}

