/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.entity.projectile;

import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.item.ItemFlorb;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityFlorb
extends EntityThrowable {
    private static DataParameter<String> FLUID = EntityDataManager.func_187226_a(EntityFlorb.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static ItemStack blockCheck = new ItemStack(Blocks.field_150348_b);
    protected float gravity = 0.03f;
    protected Fluid fluid;

    public static void initialize(int id) {
        EntityRegistry.registerModEntity(EntityFlorb.class, (String)"florb", (int)id, (Object)ThermalExpansion.instance, (int)64, (int)1, (boolean)true);
    }

    public EntityFlorb(World world) {
        super(world);
    }

    public EntityFlorb(World world, Fluid fluid) {
        super(world);
        this.fluid = fluid;
        this.setGravity();
        this.setSyncFluid();
    }

    public EntityFlorb(World world, EntityLivingBase entity, Fluid fluid) {
        super(world, entity);
        this.fluid = fluid;
        this.func_184538_a((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 1.5f, 1.0f);
        this.setGravity();
        this.setSyncFluid();
    }

    public EntityFlorb(World world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.fluid = fluid;
        this.setGravity();
        this.setSyncFluid();
    }

    public EntityFlorb(World world, Fluid fluid, int velocity) {
        this(world, fluid);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityFlorb(World world, EntityLivingBase entity, Fluid fluid, int velocity) {
        this(world, entity, fluid);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityFlorb(World world, double x, double y, double z, Fluid fluid, int velocity) {
        this(world, x, y, z, fluid);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityFlorb setFluid(Fluid fluid) {
        this.fluid = fluid;
        return this;
    }

    private void setGravity() {
        if (this.fluid.getDensity() < 0) {
            this.gravity = MathHelper.minF((float)0.01f, (float)(0.03f + 0.03f * (float)this.fluid.getDensity() / 1000.0f));
        }
    }

    private void setSyncFluid() {
        this.field_70180_af.func_187227_b(FLUID, (Object)this.fluid.getName());
    }

    private Fluid getSyncFluid() {
        return FluidRegistry.getFluid((String)((String)this.field_70180_af.func_187225_a(FLUID)));
    }

    protected void func_145775_I() {
        int j1;
        int i1;
        int l;
        int k;
        int j;
        int i = net.minecraft.util.math.MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72340_a + 0.001));
        if (this.field_70170_p.func_175707_a(new BlockPos(i, j = net.minecraft.util.math.MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b + 0.001)), k = net.minecraft.util.math.MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72339_c + 0.001))), new BlockPos(l = net.minecraft.util.math.MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72336_d - 0.001)), i1 = net.minecraft.util.math.MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72337_e - 0.001)), j1 = net.minecraft.util.math.MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72334_f - 0.001))))) {
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = j; l1 <= i1; ++l1) {
                    for (int i2 = k; i2 <= j1; ++i2) {
                        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2));
                        if (state == null) continue;
                        state.func_177230_c().func_180634_a(this.field_70170_p, new BlockPos(k1, l1, i2), state, (Entity)this);
                    }
                }
            }
        }
    }

    public void func_70030_z() {
        if (this.fluid == null && ServerHelper.isClientWorld((World)this.field_70170_p)) {
            this.fluid = this.getSyncFluid();
        }
        super.func_70030_z();
    }

    protected void func_70184_a(RayTraceResult traceResult) {
        BlockPos pos = traceResult.func_178782_a();
        if (traceResult.field_72308_g != null) {
            pos = traceResult.field_72308_g.func_180425_c().func_177982_a(0, 1, 0);
            traceResult.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
        }
        if (traceResult.field_178784_b != null && this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150431_aC) {
            pos = pos.func_177972_a(traceResult.field_178784_b);
        }
        if (ServerHelper.isServerWorld((World)this.field_70170_p)) {
            if (traceResult.field_178784_b != null && this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_175151_a(pos, traceResult.field_178784_b, blockCheck)) {
                ItemFlorb.dropFlorb(this.getFluid(), this.field_70170_p, pos);
                this.func_70106_y();
                return;
            }
            Block block = this.fluid.getBlock();
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if ("water".equals(this.fluid.getName())) {
                block = Blocks.field_150358_i;
            } else if ("lava".equals(this.fluid.getName())) {
                block = Blocks.field_150356_k;
            } else if (block == null) {
                block = Blocks.field_150358_i;
            }
            if (this.field_70170_p.func_175623_d(pos) || state.func_185904_a() == Material.field_151581_o || state.func_177230_c() == Blocks.field_150431_aC) {
                if (!this.fluid.getName().equals("water") || !this.field_70170_p.func_180494_b(pos).func_185359_l().toLowerCase().equals("hell")) {
                    this.field_70170_p.func_180501_a(pos, block.func_176223_P(), 3);
                    this.field_70170_p.func_184138_a(pos, state, state, 3);
                }
            } else {
                ItemFlorb.dropFlorb(this.getFluid(), this.field_70170_p, pos);
            }
        }
        this.func_70106_y();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FLUID, (Object)"");
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("Fluid"));
        if (this.fluid == null) {
            this.fluid = FluidRegistry.WATER;
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("Fluid", this.fluid.getName());
    }
}

