/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.blockbakery.BlockBakery;
import codechicken.lib.model.blockbakery.CCBakeryModel;
import codechicken.lib.model.blockbakery.IBakeryBlock;
import codechicken.lib.model.blockbakery.ICustomBlockBakery;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockTank;
import cofh.thermalexpansion.block.storage.TileTank;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.render.RenderTank;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends BlockTEBase
implements IBakeryBlock,
IModelRegister {
    public static boolean enable;
    public static ItemStack[] tank;
    public static ItemBlockTank itemBlock;

    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149663_c("tank");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IUnlistedProperty[]{TEProps.CREATIVE});
        builder.add(new IUnlistedProperty[]{TEProps.LEVEL});
        builder.add(new IUnlistedProperty[]{TEProps.HOLDING});
        builder.add(new IUnlistedProperty[]{TEProps.ACTIVE});
        builder.add(new IUnlistedProperty[]{TEProps.FLUID});
        return builder.build();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(@Nonnull Item item, CreativeTabs tab, List<ItemStack> list) {
        if (enable) {
            if (TEProps.creativeTabShowAllLevels) {
                for (int j = 0; j < 5; ++j) {
                    list.add(itemBlock.setDefaultTag(new ItemStack(item, 1, 0), j));
                }
            } else {
                list.add(itemBlock.setDefaultTag(new ItemStack(item, 1, 0), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                list.add(itemBlock.setCreativeTag(new ItemStack(item, 1, 0), 4));
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileTank();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileTank tile = (TileTank)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
            if (fluid != null) {
                tile.getTank().setFluid(fluid);
            }
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP || side == EnumFacing.DOWN;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            if (FluidHelper.isFluidHandler((ItemStack)heldItem) && FluidHelper.interactWithHandler((ItemStack)heldItem, (IFluidHandler)handler, (EntityPlayer)player, (EnumHand)hand)) {
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    }

    @Override
    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileTank tile = (TileTank)world.func_175625_s(pos);
        if (tile != null) {
            FluidStack fluid;
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            if ((fluid = tile.getTankFluid()) != null) {
                retTag.func_74782_a("Fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
            }
        }
        return retTag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (TileEntity)world.func_175625_s(pos));
    }

    @SideOnly(value=Side.CLIENT)
    public ICustomBlockBakery getCustomBakery() {
        return RenderTank.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper("thermalexpansion", "tank", "tank");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)mapper.location);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)mapper);
        ModelRegistryHelper.register((ModelResourceLocation)mapper.location, (IBakedModel)new CCBakeryModel("thermalexpansion:blocks/storage/tank_side_0_0"));
        BlockBakery.registerBlockKeyGenerator((Block)this, state -> {
            StringBuilder builder = new StringBuilder(BlockBakery.defaultBlockKeyGenerator.generateKey(state));
            builder.append(",creative=").append(state.getValue((IUnlistedProperty)TEProps.CREATIVE));
            builder.append(",level=").append(state.getValue((IUnlistedProperty)TEProps.LEVEL));
            builder.append(",holding=").append(state.getValue((IUnlistedProperty)TEProps.HOLDING));
            builder.append(",output=").append(state.getValue((IUnlistedProperty)TEProps.ACTIVE));
            FluidStack stack = (FluidStack)state.getValue((IUnlistedProperty)TEProps.FLUID);
            if (stack != null) {
                builder.append(",fluid=").append(stack.getFluid().getName());
                builder.append(",amount=").append(stack.amount);
            }
            return builder.toString();
        });
        BlockBakery.registerItemKeyGenerator((Item)itemBlock, stack -> {
            FluidStack fluid;
            String fluidAppend = "";
            if (stack.func_77978_p() != null && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"))) != null && fluid.amount > 0) {
                fluidAppend = ",fluid=" + fluid.getFluid().getName() + ",amount=" + fluid.amount;
            }
            return BlockBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack) + fluidAppend;
        });
    }

    public boolean preInit() {
        this.setRegistryName("tank");
        GameRegistry.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockTank((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        TileTank.initialize();
        tank = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockTank.tank[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        this.addRecipes();
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private void addRecipes() {
        if (enable) {
            ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)tank[0], (Object[])new Object[]{" I ", "ICI", " P ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "blockGlass", Character.valueOf('P'), ItemMaterial.redstoneServo}));
        }
    }
}

