/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiSmelter;
import cofh.thermalexpansion.gui.container.machine.ContainerSmelter;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileSmelter
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.SMELTER.getMetadata();
    public static int basePower = 20;
    public static int fluidAmount = 100;
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    public boolean lockPrimary = false;
    private FluidTankCore tank = new FluidTankCore(4000);
    protected boolean augmentPyrotheum;
    protected boolean flagPyrotheum;

    public static void initialize() {
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE] = new TileTEBase.SideConfig();
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].numConfig = 9;
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        TileSmelter.SIDE_CONFIGS[TileSmelter.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileSmelter.SLOT_CONFIGS[TileSmelter.TYPE] = new TileTEBase.SlotConfig();
        TileSmelter.SLOT_CONFIGS[TileSmelter.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false};
        TileSmelter.SLOT_CONFIGS[TileSmelter.TYPE].allowExtractionSlot = new boolean[]{false, false, true, true, false};
        TileSmelter.VALID_AUGMENTS[TileSmelter.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSmelterPyrotheum");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TileSmelter.LIGHT_VALUES[TileSmelter.TYPE] = 15;
        GameRegistry.registerTileEntity(TileSmelter.class, (String)"thermalexpansion:machine_smelter");
        TileSmelter.config();
    }

    public static void config() {
        String category = "Machine.Smelter";
        BlockMachine.enable[TileSmelter.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileSmelter.ENERGY_CONFIGS[TileSmelter.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileSmelter() {
        this.inventory = new ItemStack[5];
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidPyrotheum);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null || this.inventory[1] == null || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        SmelterManager.RecipeSmelter recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            return false;
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[3] != null) {
            if (!this.augmentSecondaryNull && !this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (!this.augmentSecondaryNull && this.inventory[3].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[2] == null || this.inventory[2].func_77969_a(primaryItem) && this.inventory[2].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        SmelterManager.RecipeSmelter recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            return false;
        }
        return !(SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        boolean augmentPyrotheumCheck;
        SmelterManager.RecipeSmelter recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[2].field_77994_a += primaryItem.field_77994_a;
        }
        boolean bl = augmentPyrotheumCheck = this.augmentPyrotheum && (ItemHelper.isOre((ItemStack)this.inventory[0]) || ItemHelper.isOre((ItemStack)this.inventory[1])) && this.tank.getFluidAmount() >= fluidAmount;
        if (augmentPyrotheumCheck) {
            this.tank.modifyFluidStored(-fluidAmount);
            if (this.inventory[2].field_77994_a < this.inventory[2].func_77976_d()) {
                ++this.inventory[2].field_77994_a;
            }
        }
        if (secondaryItem != null) {
            int modifiedChance = augmentPyrotheumCheck ? this.secondaryChance - 25 : this.secondaryChance;
            int recipeChance = recipe.getSecondaryOutputChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[3] == null) {
                    this.inventory[3] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                    }
                } else if (this.inventory[3].func_77969_a(secondaryItem)) {
                    this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                    if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                    }
                }
                if (this.inventory[3].field_77994_a > this.inventory[3].func_77976_d()) {
                    this.inventory[3].field_77994_a = this.inventory[3].func_77976_d();
                }
            }
        }
        if (SmelterManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            this.inventory[1].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[0].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        } else {
            this.inventory[0].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[1].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
    }

    @Override
    protected void transferInput() {
        int side;
        int i;
        if (!this.enableAutoInput) {
            return;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerPrimary = side;
            break;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[2] != null) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[3] == null) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(3, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        this.lockPrimary = tag.func_74767_n("SlotLock");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiSmelter(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerSmelter(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentPyrotheum() {
        return this.augmentPyrotheum && this.flagPyrotheum;
    }

    public boolean fluidArrow() {
        return this.augmentPyrotheum && this.tank.getFluidAmount() >= fluidAmount && (ItemHelper.isOre((ItemStack)this.inventory[0]) || ItemHelper.isOre((ItemStack)this.inventory[1]));
    }

    public void setMode(boolean mode) {
        boolean lastMode = this.lockPrimary;
        this.lockPrimary = mode;
        this.sendModePacket();
        this.lockPrimary = lastMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn1");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTrackerPrimary = nbt.func_74762_e("TrackOut1");
        this.outputTrackerSecondary = nbt.func_74762_e("TrackOut2");
        this.lockPrimary = nbt.func_74767_n("SlotLock");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn1", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("TrackOut1", this.outputTrackerPrimary);
        nbt.func_74768_a("TrackOut2", this.outputTrackerSecondary);
        nbt.func_74757_a("SlotLock", this.lockPrimary);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addBool(this.lockPrimary);
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.lockPrimary = payload.getBool();
        this.callNeighborTileChange();
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.lockPrimary);
        payload.addBool(this.augmentPyrotheum);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.lockPrimary = payload.getBool();
        this.flagPyrotheum = this.augmentPyrotheum = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentPyrotheum = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentPyrotheum) {
            this.tank.modifyFluidStored(-this.tank.getCapacity());
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentPyrotheum && "machineSmelterPyrotheum".equals(id)) {
            this.augmentPyrotheum = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.lockPrimary) {
            if (slot == 0) {
                return SmelterManager.isItemFlux(stack);
            }
            if (slot == 1) {
                return !SmelterManager.isItemFlux(stack) && SmelterManager.isItemValid(stack);
            }
        }
        return slot > 1 || SmelterManager.isItemValid(stack);
    }

    @Override
    public SoundEvent getSoundEvent() {
        return TESounds.MACHINE_SMELTER;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentPyrotheum && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentPyrotheum && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileSmelter.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileSmelter.this.allowInsertion(((TileSmelter)TileSmelter.this).sideConfig.sideTypes[TileSmelter.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileSmelter.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

