/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiInsolator;
import cofh.thermalexpansion.gui.container.machine.ContainerInsolator;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileInsolator
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.INSOLATOR.getMetadata();
    public static int basePower = 20;
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    public boolean lockPrimary = false;
    private FluidTankCore tank = new FluidTankCore(10000);
    protected boolean augmentMycelium;
    protected boolean augmentNether;
    protected boolean augmentEnd;
    protected boolean augmentTree;

    public static void initialize() {
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE] = new TileTEBase.SideConfig();
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].numConfig = 9;
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {3}, {2, 3}, {0}, {1}, {0, 1, 2, 3}, {0, 1, 2, 3}};
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        TileInsolator.SIDE_CONFIGS[TileInsolator.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileInsolator.SLOT_CONFIGS[TileInsolator.TYPE] = new TileTEBase.SlotConfig();
        TileInsolator.SLOT_CONFIGS[TileInsolator.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false, false};
        TileInsolator.SLOT_CONFIGS[TileInsolator.TYPE].allowExtractionSlot = new boolean[]{false, false, true, true, false};
        TileInsolator.VALID_AUGMENTS[TileInsolator.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineInsolatorMycelium");
        VALID_AUGMENTS[TYPE].add("machineInsolatorNether");
        VALID_AUGMENTS[TYPE].add("machineInsolatorEnd");
        VALID_AUGMENTS[TYPE].add("machineInsolatorTree");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TileInsolator.LIGHT_VALUES[TileInsolator.TYPE] = 14;
        GameRegistry.registerTileEntity(TileInsolator.class, (String)"thermalexpansion:machine_insolator");
        TileInsolator.config();
    }

    public static void config() {
        String category = "Machine.Insolator";
        BlockMachine.enable[TileInsolator.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileInsolator.ENERGY_CONFIGS[TileInsolator.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TileInsolator() {
        this.inventory = new ItemStack[5];
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0] == null || this.inventory[1] == null || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        InsolatorManager.RecipeInsolator recipe = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null || this.tank.getFluidAmount() < recipe.getEnergy() / 10) {
            return false;
        }
        InsolatorManager.Type substrate = recipe.getType();
        switch (substrate) {
            case STANDARD: {
                break;
            }
            case MYCELIUM: {
                if (this.augmentMycelium) break;
                return false;
            }
            case NETHER: {
                if (this.augmentNether) break;
                return false;
            }
            case END: {
                if (this.augmentEnd) break;
                return false;
            }
            case TREE: {
                if (this.augmentTree) break;
                return false;
            }
            case MYCELIUM_TREE: {
                if (this.augmentTree && this.augmentMycelium) break;
                return false;
            }
            case NETHER_TREE: {
                if (this.augmentTree && this.augmentNether) break;
                return false;
            }
            case END_TREE: {
                if (this.augmentTree && this.augmentEnd) break;
                return false;
            }
        }
        if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[3] != null) {
            if (!this.augmentSecondaryNull && !this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (!this.augmentSecondaryNull && this.inventory[3].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[2] == null || this.inventory[2].func_77969_a(primaryItem) && this.inventory[2].field_77994_a + primaryItem.field_77994_a <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        InsolatorManager.RecipeInsolator recipe = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            return false;
        }
        return !(InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]).getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        InsolatorManager.RecipeInsolator recipe = InsolatorManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            this.processOff();
            return;
        }
        this.tank.drain(recipe.getEnergy() / 10, true);
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[2].field_77994_a += primaryItem.field_77994_a;
        }
        if (secondaryItem != null) {
            int modifiedChance = this.secondaryChance;
            int recipeChance = recipe.getSecondaryOutputChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[3] == null) {
                    this.inventory[3] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                    if (this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                    }
                } else if (this.inventory[3].func_77969_a(secondaryItem)) {
                    this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                    if (this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                        this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                    }
                }
                if (this.inventory[3].field_77994_a > this.inventory[3].func_77976_d()) {
                    this.inventory[3].field_77994_a = this.inventory[3].func_77976_d();
                }
            }
        }
        if (InsolatorManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            this.inventory[1].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[0].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        } else {
            this.inventory[0].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[1].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
    }

    @Override
    protected int processTick() {
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(-energy);
        this.processRem -= energy;
        return energy;
    }

    @Override
    protected void transferInput() {
        int side;
        int i;
        if (!this.enableAutoInput) {
            return;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!this.isPrimaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerPrimary = side;
            break;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryInput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[2] != null) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[3] == null) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!this.isSecondaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(3, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        this.lockPrimary = tag.func_74767_n("SlotLock");
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiInsolator(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerInsolator(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(boolean mode) {
        boolean lastMode = this.lockPrimary;
        this.lockPrimary = mode;
        this.sendModePacket();
        this.lockPrimary = lastMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn1");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTrackerPrimary = nbt.func_74762_e("Tracker1");
        this.outputTrackerSecondary = nbt.func_74762_e("Tracker2");
        this.lockPrimary = nbt.func_74767_n("SlotLock");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn1", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("Tracker1", this.outputTrackerPrimary);
        nbt.func_74768_a("Tracker2", this.outputTrackerSecondary);
        nbt.func_74757_a("SlotLock", this.lockPrimary);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addBool(this.lockPrimary);
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.lockPrimary = payload.getBool();
        this.callNeighborTileChange();
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addBool(this.lockPrimary);
        payload.addInt(this.tank.getFluidAmount());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.lockPrimary = payload.getBool();
        this.tank.getFluid().amount = payload.getInt();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentMycelium = false;
        this.augmentNether = false;
        this.augmentEnd = false;
        this.augmentTree = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentMycelium && "machineInsolatorMycelium".equals(id)) {
            this.augmentMycelium = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentNether && "machineInsolatorNether".equals(id)) {
            this.augmentNether = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentEnd && "machineInsolatorEnd".equals(id)) {
            this.augmentEnd = true;
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentTree && "machineInsolatorTree".equals(id)) {
            this.augmentTree = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.lockPrimary) {
            if (slot == 0) {
                return InsolatorManager.isItemFertilizer(stack);
            }
            if (slot == 1) {
                return !InsolatorManager.isItemFertilizer(stack) && InsolatorManager.isItemValid(stack);
            }
        }
        return slot > 1 || InsolatorManager.isItemValid(stack);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileInsolator.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TileInsolator.this.allowInsertion(((TileInsolator)TileInsolator.this).sideConfig.sideTypes[TileInsolator.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    return TileInsolator.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

