/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.inventory.InventoryCraftingFalse;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCrafter;
import cofh.thermalexpansion.gui.container.machine.ContainerCrafter;
import cofh.thermalfoundation.util.helpers.SchematicHelper;
import java.util.HashSet;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCrafter
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CRAFTER.getMetadata();
    public static final int PROCESS_ENERGY = 20;
    private boolean needsCache = true;
    private boolean needsCraft = false;
    private int outputTracker;
    private FluidTankCore tank = new FluidTankCore(10000);
    private InventoryCrafting crafting = new InventoryCraftingFalse(3, 3);
    private ItemStack recipeOutput;
    private FluidStack[] filledContainer = new FluidStack[9];
    private ItemStack[] recipeSlot = new ItemStack[9];
    private String[] recipeOre = new String[9];

    public static void initialize() {
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SideConfig();
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].numConfig = 6;
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].slotGroups = new int[][]{new int[0], {3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {1}, {3, 4, 5, 6, 7, 8, 9, 10, 11}, {12, 13, 14, 15, 16, 17, 18, 19, 20}, {0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}};
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].sideTypes = new int[]{0, 1, 4, 5, 6, 7};
        TileCrafter.SIDE_CONFIGS[TileCrafter.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE] = new TileTEBase.SlotConfig();
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE].allowInsertionSlot = new boolean[]{true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        TileCrafter.SLOT_CONFIGS[TileCrafter.TYPE].allowExtractionSlot = new boolean[]{true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        TileCrafter.VALID_AUGMENTS[TileCrafter.TYPE] = new HashSet();
        GameRegistry.registerTileEntity(TileCrafter.class, (String)"thermalexpansion:machine_crafter");
        TileCrafter.config();
    }

    public static void config() {
        String category = "Machine.Crafter";
        BlockMachine.enable[TileCrafter.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TileCrafter.ENERGY_CONFIGS[TileCrafter.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(20);
    }

    public TileCrafter() {
        this.inventory = new ItemStack[21];
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.redstoneControlOrDisable()) {
            if (this.needsCraft) {
                this.updateOutput();
            }
            if (this.timeCheck()) {
                this.transferOutput();
            }
        } else {
            if (this.isActive) {
                this.wasActive = true;
            }
            this.isActive = false;
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public int getChargeSlot() {
        return 2;
    }

    private boolean canCreate(ItemStack recipe) {
        return recipe != null && (this.inventory[1] == null || recipe.func_77969_a(this.inventory[1]) && this.inventory[1].field_77994_a + recipe.field_77994_a <= recipe.func_77976_d());
    }

    private boolean createItem() {
        if (this.energyStorage.getEnergyStored() < 20) {
            return false;
        }
        ItemStack[] invCopy = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        FluidStack fluidCopy = null;
        if (this.tank.getFluid() != null) {
            fluidCopy = this.tank.getFluid().copy();
        }
        boolean found = false;
        for (int i = 0; i < 9; ++i) {
            if (fluidCopy != null && fluidCopy.isFluidEqual(this.filledContainer[i]) && fluidCopy.amount >= this.filledContainer[i].amount) {
                fluidCopy.amount -= this.filledContainer[i].amount;
                this.crafting.func_70299_a(i, this.recipeSlot[i].func_77946_l());
                continue;
            }
            if (this.recipeSlot[i] != null) {
                for (int j = 2; j < invCopy.length; ++j) {
                    ItemStack containerStack;
                    if (invCopy[j] == null || !ItemHelper.craftingEquivalent((ItemStack)invCopy[j], (ItemStack)this.recipeSlot[i], (String)this.recipeOre[i], (ItemStack)this.recipeOutput)) continue;
                    this.crafting.func_70299_a(i, invCopy[j].func_77946_l());
                    --invCopy[j].field_77994_a;
                    if (invCopy[j].func_77973_b().hasContainerItem(invCopy[j]) && (containerStack = invCopy[j].func_77973_b().getContainerItem(invCopy[j])) != null) {
                        if (containerStack.func_77984_f() && containerStack.func_77952_i() > containerStack.func_77958_k()) {
                            containerStack = null;
                        }
                        if (containerStack != null && !InventoryHelper.addItemStackToInventory((ItemStack[])invCopy, (ItemStack)containerStack, (int)3)) {
                            if (invCopy[j].field_77994_a <= 0) {
                                invCopy[j] = containerStack;
                                if (containerStack.field_77994_a <= 0) {
                                    invCopy[j].field_77994_a = 1;
                                }
                            } else {
                                return false;
                            }
                        }
                    }
                    if (invCopy[j].field_77994_a <= 0) {
                        invCopy[j] = null;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
                found = false;
                continue;
            }
            this.crafting.func_70299_a(i, null);
        }
        this.inventory = invCopy;
        if (fluidCopy == null || fluidCopy.amount <= 0) {
            fluidCopy = null;
        }
        this.tank.setFluid(fluidCopy);
        this.energyStorage.modifyEnergyStored(-20);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateOutput() {
        if (this.inventory[0] == null) return;
        if (this.needsCache) {
            this.recipeOutput = SchematicHelper.getOutput((ItemStack)this.inventory[0], (World)this.field_145850_b);
            for (int i = 0; i < 9; ++i) {
                this.recipeSlot[i] = SchematicHelper.getSchematicSlot((ItemStack)this.inventory[0], (int)i);
                this.filledContainer[i] = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.recipeSlot[i]);
                this.recipeOre[i] = SchematicHelper.getSchematicOreSlot((ItemStack)this.inventory[0], (int)i);
            }
            this.needsCache = false;
        }
        if (this.recipeOutput == null) {
            this.isActive = false;
            return;
        }
        if (this.canCreate(this.recipeOutput)) {
            if (this.createItem()) {
                this.recipeOutput = ItemHelper.findMatchingRecipe((InventoryCrafting)this.crafting, (World)this.field_145850_b);
                if (this.recipeOutput == null) return;
                if (this.inventory[1] == null) {
                    this.inventory[1] = this.recipeOutput.func_77946_l();
                } else {
                    this.inventory[1].field_77994_a += this.recipeOutput.field_77994_a;
                }
                this.transferOutput();
                this.isActive = true;
                return;
            }
            if (this.energyStorage.getEnergyStored() >= 20) {
                this.needsCraft = false;
            }
            this.wasActive = true;
            this.isActive = false;
            return;
        }
        if (this.isActive) {
            this.wasActive = true;
        }
        this.isActive = false;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("Output");
        this.needsCraft = true;
        this.needsCache = true;
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Output", this.outputTracker);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addFluidStack(this.getTankFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    public void func_70296_d() {
        this.needsCraft = true;
        super.func_70296_d();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        this.needsCraft = true;
        this.needsCache = this.needsCache || slot == 0;
        return super.func_70298_a(slot, amount);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.needsCraft = true;
        this.needsCache = this.needsCache || slot == 0;
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }
}

