/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import codechicken.lib.texture.TextureUtils;
import cofh.api.core.IAccelerable;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.item.IAugmentItem;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.core.fluid.FluidTankCore;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileInventory;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import java.util.HashSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileDynamoBase
extends TileInventory
implements ITickable,
IAccelerable,
IEnergyProvider,
IEnergyInfo,
IReconfigurableFacing,
ISidedInventory {
    protected static final TileTEBase.EnergyConfig[] DEFAULT_ENERGY_CONFIG = new TileTEBase.EnergyConfig[BlockDynamo.Type.values().length];
    protected static final HashSet<String>[] VALID_AUGMENTS = new HashSet[BlockDynamo.Type.values().length];
    private static boolean enableSecurity = true;
    protected static final HashSet<String> VALID_AUGMENTS_BASE = new HashSet();
    protected static final int ENERGY_BASE = 100;
    byte facing = 1;
    int fuelRF;
    boolean wasActive;
    boolean hasModeAugment;
    int compareTracker;
    boolean cached = false;
    IEnergyReceiver adjacentReceiver = null;
    boolean adjacentHandler = false;
    EnergyStorage energyStorage;
    TileTEBase.EnergyConfig energyConfig;
    TimeTracker tracker = new TimeTracker();
    protected boolean augmentCoilDuct;
    protected boolean augmentThrottle;
    int energyMod = 100;

    public static void config() {
        String comment = "Enable this to allow for Dynamos to be securable.";
        enableSecurity = ThermalExpansion.CONFIG.get("Security", "Dynamo.Securable", enableSecurity, comment);
    }

    public TileDynamoBase() {
        this.energyConfig = DEFAULT_ENERGY_CONFIG[this.getType()].copy();
        this.energyStorage = new EnergyStorage(this.energyConfig.maxEnergy, this.energyConfig.maxPower * 2);
    }

    public String getTileName() {
        return "tile.thermalexpansion.dynamo." + BlockDynamo.Type.values()[this.getType()].func_176610_l() + ".name";
    }

    public int getComparatorInputOverride() {
        return this.compareTracker;
    }

    public int getLightValue() {
        return this.isActive ? 7 : 0;
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    protected boolean setLevel(int level) {
        if (super.setLevel(level)) {
            this.energyConfig.setDefaultParams(this.getBasePower(this.level));
            this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
            return true;
        }
        return false;
    }

    public boolean onWrench(EntityPlayer player, EnumFacing side) {
        return this.rotateBlock();
    }

    @Override
    public void blockPlaced() {
        super.blockPlaced();
        byte oldFacing = this.facing;
        int e = this.facing + 6;
        for (int i = this.facing + 1; i < e; ++i) {
            if (!EnergyHelper.isAdjacentEnergyReceiverFromSide((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i % 6]) && !EnergyHelper.isAdjacentEnergyHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[i % 6])) continue;
            this.facing = (byte)(i % 6);
            if (this.facing == oldFacing) continue;
            this.updateAdjacentHandlers();
            this.markChunkDirty();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public void func_145843_s() {
        this.cached = false;
        super.func_145843_s();
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(BlockPos pos) {
        super.onNeighborTileChange(pos);
        this.updateAdjacentHandlers();
    }

    public final void setEnergyStored(int quantity) {
        this.energyStorage.setEnergyStored(quantity);
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canFinish()) {
                if (!this.redstoneControlOrDisable() || !this.canStart()) {
                    this.processOff();
                } else {
                    this.processStart();
                }
            }
        } else if (this.redstoneControlOrDisable() && this.timeCheck()) {
            if (this.canStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            } else {
                this.processIdle();
            }
        }
        if (this.timeCheck()) {
            int curScale = this.getScaledEnergyStored(15);
            if (curScale != this.compareTracker) {
                this.compareTracker = curScale;
                this.callNeighborTileChange();
            }
            if (!this.cached) {
                this.onNeighborBlockChange();
            }
        }
        this.updateIfChanged(curActive);
    }

    int getBasePower(int level) {
        return TileDynamoBase.DEFAULT_ENERGY_CONFIG[this.getType()].maxPower + level * TileDynamoBase.DEFAULT_ENERGY_CONFIG[this.getType()].maxPower / 2;
    }

    int calcEnergy() {
        if (this.energyStorage.getEnergyStored() < this.energyConfig.minPowerLevel) {
            return this.energyConfig.maxPower;
        }
        if (this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel) {
            return this.energyConfig.minPower;
        }
        return (this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored()) / this.energyConfig.energyRamp;
    }

    int getScaledEnergyStored(int scale) {
        return this.energyStorage.getEnergyStored() * scale / this.energyStorage.getMaxEnergyStored();
    }

    abstract boolean canStart();

    boolean canFinish() {
        return this.fuelRF <= 0;
    }

    abstract void processStart();

    protected void processFinish() {
    }

    protected void processIdle() {
    }

    protected void processOff() {
        this.isActive = false;
        this.wasActive = true;
        this.tracker.markTime(this.field_145850_b);
    }

    protected int processTick() {
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(energy);
        this.fuelRF -= energy;
        this.transferEnergy();
        return energy;
    }

    protected void transferEnergy() {
        if (this.adjacentReceiver == null) {
            if (this.adjacentHandler) {
                this.energyStorage.modifyEnergyStored(-EnergyHelper.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[this.facing], (int)Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored()), (boolean)false));
            }
            return;
        }
        this.energyStorage.modifyEnergyStored(-this.adjacentReceiver.receiveEnergy(EnumFacing.field_82609_l[this.facing ^ 1], Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored()), false));
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)this.facing);
        if (EnergyHelper.isEnergyReceiverFromSide((TileEntity)tile, (EnumFacing)EnumFacing.field_82609_l[this.facing ^ 1])) {
            this.adjacentReceiver = (IEnergyReceiver)tile;
            this.adjacentHandler = false;
        } else if (EnergyHelper.isEnergyHandler((TileEntity)tile, (EnumFacing)EnumFacing.field_82609_l[this.facing ^ 1])) {
            this.adjacentReceiver = null;
            this.adjacentHandler = true;
        } else {
            this.adjacentReceiver = null;
            this.adjacentHandler = false;
        }
        this.cached = true;
    }

    protected void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive && !this.wasActive) {
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        } else if (this.wasActive && this.tracker.hasDelayPassed(this.field_145850_b, 100)) {
            this.wasActive = false;
            this.updateLighting();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public TextureAtlasSprite getActiveIcon() {
        return TextureUtils.getTexture((ResourceLocation)FluidRegistry.WATER.getStill());
    }

    public int getScaledDuration(int scale) {
        return 0;
    }

    public cofh.api.energy.IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTankCore getTank(int tankIndex) {
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.facing = (byte)(nbt.func_74771_c("Facing") % 6);
        this.fuelRF = nbt.func_74762_e("Fuel");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74768_a("Fuel", this.fuelRF);
        return nbt;
    }

    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addInt(this.energyStorage.getMaxEnergyStored());
        payload.addInt(this.energyStorage.getEnergyStored());
        payload.addInt(this.fuelRF);
        return payload;
    }

    @Override
    public PacketCoFHBase getTilePacket() {
        PacketCoFHBase payload = super.getTilePacket();
        payload.addByte(this.facing);
        payload.addBool(this.hasRedstoneControl);
        return payload;
    }

    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.energyStorage.setCapacity(payload.getInt());
        this.energyStorage.setEnergyStored(payload.getInt());
        this.fuelRF = payload.getInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        super.handleTilePacket(payload);
        this.facing = payload.getByte();
        this.hasRedstoneControl = payload.getBool();
    }

    @Override
    protected void preAugmentInstall() {
        this.energyConfig.setDefaultParams(this.getBasePower(this.level));
        this.energyMod = 100;
        this.hasModeAugment = false;
        this.augmentThrottle = false;
        this.augmentCoilDuct = false;
    }

    @Override
    protected void postAugmentInstall() {
        if (this.augmentThrottle) {
            this.energyConfig.minPower = 0;
        }
        this.energyStorage.setCapacity(this.energyConfig.maxEnergy).setMaxTransfer(this.energyConfig.maxPower * 4);
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (type == IAugmentItem.AugmentType.CREATIVE && !this.isCreative) {
            return false;
        }
        if (type == IAugmentItem.AugmentType.MODE && this.hasModeAugment) {
            return false;
        }
        if (this.augmentCoilDuct && "dynamoCoilDuct".equals(id)) {
            return false;
        }
        if (this.augmentThrottle && "dynamoThrottle".equals(id)) {
            return false;
        }
        return VALID_AUGMENTS_BASE.contains(id) || VALID_AUGMENTS[this.getType()].contains(id) || super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("dynamoPower".equals(id)) {
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level));
            this.energyMod -= 10;
            return true;
        }
        if ("dynamoEfficiency".equals(id)) {
            this.energyMod += 15;
            return true;
        }
        if (!this.augmentCoilDuct && "dynamoCoilDuct".equals(id)) {
            this.augmentCoilDuct = true;
            return true;
        }
        if (!this.augmentThrottle && "dynamoThrottle".equals(id)) {
            this.augmentThrottle = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public int updateAccelerable() {
        if (!this.isActive || this.canFinish()) {
            return 0;
        }
        return this.processTick();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return from.ordinal() != this.facing ? 0 : this.energyStorage.extractEnergy(Math.min(this.energyConfig.maxPower * 2, maxExtract), simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getInfoEnergyPerTick() {
        if (!this.isActive) {
            return 0;
        }
        return this.calcEnergy();
    }

    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower;
    }

    public int getInfoEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getInfoMaxEnergyStored() {
        return this.energyConfig.maxEnergy;
    }

    @Override
    public String getDataType() {
        return "tile.thermalexpansion.dynamo";
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return true;
    }

    public boolean rotateBlock() {
        if (this.field_145850_b.func_72872_a(Entity.class, this.func_145838_q().func_185496_a(this.field_145850_b.func_180495_p(this.field_174879_c), (IBlockAccess)this.field_145850_b, this.field_174879_c)).size() != 0) {
            return false;
        }
        this.facing = (byte)(this.facing + 1);
        this.facing = (byte)(this.facing % 6);
        this.updateAdjacentHandlers();
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return CoreProps.EMPTY_INVENTORY;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return (this.augmentCoilDuct || side.ordinal() != this.facing) && this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return this.augmentCoilDuct || side.ordinal() != this.facing;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityEnergy.ENERGY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return 0;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return TileDynamoBase.this.extractEnergy(from, maxExtract, simulate);
                }

                public int getEnergyStored() {
                    return TileDynamoBase.this.getEnergyStored(from);
                }

                public int getMaxEnergyStored() {
                    return TileDynamoBase.this.getMaxEnergyStored(from);
                }

                public boolean canExtract() {
                    return true;
                }

                public boolean canReceive() {
                    return false;
                }
            });
        }
        return super.getCapability(capability, from);
    }

    static {
        VALID_AUGMENTS_BASE.add("dynamoPower");
        VALID_AUGMENTS_BASE.add("dynamoEfficiency");
        VALID_AUGMENTS_BASE.add("dynamoCoilDuct");
        VALID_AUGMENTS_BASE.add("dynamoThrottle");
    }
}

