/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block;

import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.TileAugmentableSecure;
import cofh.thermalexpansion.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileInventory
extends TileAugmentableSecure
implements IInventory {
    public ItemStack[] inventory = new ItemStack[0];

    public boolean extractItem(int slot, int amount, EnumFacing side) {
        if (slot > this.inventory.length) {
            return false;
        }
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            amount = Math.min(amount, stack.func_77976_d() - stack.field_77994_a);
            stack = this.inventory[slot].func_77946_l();
        }
        int initialAmount = amount;
        TileEntity adjInv = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)side);
        if (Utils.isAccessibleInput(adjInv, side)) {
            IItemHandler inv = (IItemHandler)adjInv.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
            if (inv == null) {
                return false;
            }
            for (int i = 0; i < inv.getSlots() && amount > 0; ++i) {
                int toExtract;
                ItemStack queryStack = inv.extractItem(i, amount, true);
                if (queryStack == null) continue;
                if (stack == null) {
                    if (!this.func_94041_b(slot, queryStack)) continue;
                    toExtract = Math.min(amount, queryStack.field_77994_a);
                    stack = inv.extractItem(i, toExtract, false);
                    amount -= toExtract;
                    continue;
                }
                if (!ItemHelper.itemsEqualWithMetadata((ItemStack)stack, (ItemStack)queryStack, (boolean)true)) continue;
                ItemStack extracted = inv.extractItem(i, toExtract = Math.min(stack.func_77976_d() - stack.field_77994_a, Math.min(amount, queryStack.field_77994_a)), false);
                toExtract = Math.min(toExtract, extracted == null ? 0 : extracted.field_77994_a);
                stack.field_77994_a += toExtract;
                amount -= toExtract;
            }
            if (initialAmount != amount) {
                this.inventory[slot] = stack;
                adjInv.func_70296_d();
                return true;
            }
        }
        return false;
    }

    public boolean transferItem(int slot, int amount, EnumFacing side) {
        if (this.inventory[slot] == null || slot > this.inventory.length) {
            return false;
        }
        ItemStack stack = this.inventory[slot].func_77946_l();
        stack.field_77994_a = amount = Math.min(amount, stack.field_77994_a);
        TileEntity curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)side);
        if (Utils.isAccessibleOutput(curTile, side)) {
            int added = Utils.addToInsertion(curTile, side, stack);
            if (added >= amount) {
                return false;
            }
            this.inventory[slot].field_77994_a -= amount - added;
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getInvSlotCount() {
        return this.inventory.length;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readInventoryFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeInventoryToNBT(nbt);
        return nbt;
    }

    public void readInventoryFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void writeInventoryToNBT(NBTTagCompound nbt) {
        if (this.inventory.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            this.inventory[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        if (list.func_74745_c() > 0) {
            nbt.func_74782_a("Inventory", (NBTBase)list);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= amount) {
            amount = this.inventory[slot].field_77994_a;
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].field_77994_a <= 0) {
            this.inventory[slot] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] == null) {
            return null;
        }
        ItemStack stack = this.inventory[slot];
        this.inventory[slot] = null;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.markChunkDirty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUsable(player);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, from);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this instanceof ISidedInventory && facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this));
        }
        return (T)super.getCapability(capability, facing);
    }
}

