/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.table;

import engineers.workshop.EngineersWorkshop;
import engineers.workshop.client.container.slot.SlotBase;
import engineers.workshop.client.renderer.PowerTESR;
import engineers.workshop.common.loaders.CreativeTabLoader;
import engineers.workshop.common.table.TileTable;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTable
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockTable() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149647_a(CreativeTabLoader.tabWorkshop);
        this.setRegistryName("engineersworkshop:blockTable");
        this.func_149663_c("engineersworkshop:blockTable");
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
        GameRegistry.registerTileEntity(TileTable.class, (String)"engineersworkshop:blockTable");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)BlockTable.getFacingFromEntity(pos, placer)), 2);
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entity) {
        return EnumFacing.func_176737_a((float)((float)(entity.field_70165_t - (double)clickedBlock.func_177958_n())), (float)((float)(entity.field_70163_u - (double)clickedBlock.func_177956_o())), (float)((float)(entity.field_70161_v - (double)clickedBlock.func_177952_p())));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileTable.class, (TileEntitySpecialRenderer)new PowerTESR());
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTable();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)EngineersWorkshop.instance, (int)0, (World)worldIn, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            if (!player.func_184812_l_()) {
                this.dropInventory(world, pos);
            }
            world.func_175655_b(pos, !player.func_184812_l_());
        }
        return false;
    }

    protected void dropInventory(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileTable) {
                TileTable table = (TileTable)tileEntity;
                for (SlotBase slot : table.getSlots()) {
                    ItemStack itemStack;
                    if (!slot.shouldDropOnClosing() || (itemStack = slot.func_75211_c()) == null || itemStack.field_77994_a <= 0) continue;
                    Random random = new Random();
                    float dX = random.nextFloat() * 0.8f + 0.1f;
                    float dY = random.nextFloat() * 0.8f + 0.1f;
                    float dZ = random.nextFloat() * 0.8f + 0.1f;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.func_77946_l());
                    if (itemStack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
                    }
                    float factor = 0.05f;
                    entityItem.field_70159_w = random.nextGaussian() * (double)factor;
                    entityItem.field_70159_w = random.nextGaussian() * (double)factor + 0.2;
                    entityItem.field_70159_w = random.nextGaussian() * (double)factor;
                    world.func_72838_d((Entity)entityItem);
                    itemStack.field_77994_a = 0;
                }
            }
        }
    }
}

