/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page.unit;

import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import engineers.workshop.client.container.slot.crushing.SlotUnitCrusherInput;
import engineers.workshop.client.container.slot.crushing.SlotUnitCrusherQueue;
import engineers.workshop.client.container.slot.crushing.SlotUnitCrusherResult;
import engineers.workshop.client.page.Page;
import engineers.workshop.client.page.unit.Unit;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import engineers.workshop.common.util.Logger;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.OreDictionary;

public class UnitCrush
extends Unit {
    private int inputId;
    private int outputId;
    private int queueId;
    private static final int QUEUE_MAX_COUNT = 3;
    private static final int QUEUE_X = 5;
    private static final int QUEUE_Y = 5;
    private static final int START_X = 25;
    private static final int START_Y = 23;
    private static final int RESULT_X = 56;
    private static final int SLOT_SIZE = 18;
    private static final int[] QUEUE_ORDER = new int[]{2, 0, 1};
    private static final int[] QUEUE_ORDER_START = new int[]{1, 1, 0};
    private static final int ARROW_X = 25;
    private static final int ARROW_Y = 1;
    private static HashMap<ItemStack, ItemStack> sawRecipies = new HashMap();

    public UnitCrush(TileTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        this.inputId = id;
        this.addSlot(new SlotUnitCrusherInput(this.table, this.page, id++, this.x + 25, this.y + 23, this));
        this.outputId = id;
        this.addSlot(new SlotUnitCrusherResult(this.table, this.page, id++, this.x + 25 + 56, this.y + 23, this));
        this.queueId = id;
        for (int i = 0; i < 3; ++i) {
            this.addSlot(new SlotUnitCrusherQueue(this.table, this.page, id++, this.x + 5, this.y + 5 + i * 18, this, QUEUE_ORDER[i]));
        }
        return id;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int queueLength = this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.QUEUE);
        if (queueLength > 0) {
            int start = QUEUE_ORDER_START[queueLength - 1];
            for (int i = start + queueLength - 1; i >= start; --i) {
                int targetId = i == start + queueLength - 1 ? this.inputId : this.queueId + i + 1;
                int sourceId = this.queueId + i;
                ItemStack target = this.table.func_70301_a(targetId);
                ItemStack source = this.table.func_70301_a(sourceId);
                if (source == null) continue;
                ItemStack move = source.func_77946_l();
                move.field_77994_a = 1;
                if (!this.canMove(move, target)) continue;
                if (target == null) {
                    this.table.func_70299_a(targetId, move);
                } else {
                    ++target.field_77994_a;
                }
                --source.field_77994_a;
                if (source.field_77994_a != 0) continue;
                this.table.func_70299_a(sourceId, null);
            }
        }
    }

    @Override
    protected ItemStack getProductionResult() {
        ItemStack input = this.table.func_70301_a(this.inputId);
        if (this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.AXE) > 0) {
            for (ItemStack stack : sawRecipies.keySet()) {
                if (!this.isMatching(stack, input)) continue;
                return sawRecipies.get(stack);
            }
        }
        IRecipe ir = SagMillRecipeManager.getInstance().getRecipeForInput(input);
        return input == null ? null : (ir == null ? null : ir.getOutputs()[0].getOutput());
    }

    public boolean isMatching(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77973_b() != null & stack2.func_77973_b() != null && stack1.func_77973_b() == stack2.func_77973_b();
    }

    @Override
    protected void onProduction(ItemStack result) {
        this.table.func_70298_a(this.inputId, 1);
    }

    @Override
    public int getOutputId() {
        return this.outputId;
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return item != null && Upgrade.ParentType.CRUSHING.isValidParent(item);
    }

    @Override
    public int getArrowX() {
        return 50;
    }

    @Override
    public int getArrowY() {
        return 24;
    }

    public static void addLogSawRecipies() {
        Logger.info("Adding saw recipes to crusher.");
        Container tempContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        InventoryCrafting tempCrafting = new InventoryCrafting(tempContainer, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCrafting.func_70299_a(i, null);
        }
        List registeredOres = OreDictionary.getOres((String)"logWood");
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack logEntry = (ItemStack)registeredOres.get(i);
            if (logEntry.func_77952_i() == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    ItemStack log = ItemStack.func_77944_b((ItemStack)logEntry);
                    log.func_77964_b(j);
                    tempCrafting.func_70299_a(0, log);
                    ItemStack resultEntry = CraftingManager.func_77594_a().func_82787_a(tempCrafting, null);
                    if (resultEntry == null) continue;
                    ItemStack result = resultEntry.func_77946_l();
                    result.field_77994_a = (int)((double)result.field_77994_a * 1.5);
                    sawRecipies.put(log, result);
                }
                continue;
            }
            ItemStack log = ItemStack.func_77944_b((ItemStack)logEntry);
            tempCrafting.func_70299_a(0, log);
            ItemStack resultEntry = CraftingManager.func_77594_a().func_82787_a(tempCrafting, null);
            if (resultEntry == null) continue;
            ItemStack result = resultEntry.func_77946_l();
            result.field_77994_a = (int)((double)result.field_77994_a * 1.5);
            sawRecipies.put(log, result);
        }
    }
}

