/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page.unit;

import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.alloy.AlloyRecipeManager;
import crazypants.enderio.machine.recipe.IRecipe;
import engineers.workshop.client.GuiBase;
import engineers.workshop.client.container.slot.alloying.SlotUnitAlloyInput;
import engineers.workshop.client.container.slot.alloying.SlotUnitAlloyQueue;
import engineers.workshop.client.container.slot.alloying.SlotUnitAlloyResult;
import engineers.workshop.client.page.Page;
import engineers.workshop.client.page.unit.Unit;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UnitAlloy
extends Unit {
    private int inputId;
    private int inputSize = 3;
    private int outputId;
    private int queueId;
    private static final int QUEUE_MAX_COUNT = 3;
    private static final int QUEUE_X = 5;
    private static final int QUEUE_Y = 5;
    private static final int START_X = 25;
    private static final int START_Y = 23;
    private static final int RESULT_X = 56;
    private static final int SLOT_SIZE = 18;
    private static final int[] QUEUE_ORDER = new int[]{2, 0, 1};
    private static final int[] QUEUE_ORDER_START = new int[]{1, 1, 0};
    private static final int ARROW_X = 25;
    private static final int ARROW_Y = 1;

    public UnitAlloy(TileTable table, Page page, int id, int x, int y) {
        super(table, page, id, x, y);
    }

    @Override
    public int createSlots(int id) {
        this.inputId = id;
        this.addSlot(new SlotUnitAlloyInput(this.table, this.page, id++, this.x + 25, this.y + 23, this));
        this.addSlot(new SlotUnitAlloyInput(this.table, this.page, id++, this.x + 25 - 9, this.y + 23 + 18, this));
        this.addSlot(new SlotUnitAlloyInput(this.table, this.page, id++, this.x + 25 + 9, this.y + 23 + 18, this));
        this.outputId = id;
        this.addSlot(new SlotUnitAlloyResult(this.table, this.page, id++, this.x + 25 + 56, this.y + 23, this));
        this.queueId = id;
        for (int i = 0; i < 3; ++i) {
            this.addSlot(new SlotUnitAlloyQueue(this.table, this.page, id++, this.x + 5, this.y + 5 + i * 18, this, QUEUE_ORDER[i]));
        }
        return id;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int queueLength = this.table.getUpgradePage().getUpgradeCount(this.id, Upgrade.QUEUE);
        if (queueLength > 0) {
            int start = QUEUE_ORDER_START[queueLength - 1];
            for (int i = start + queueLength - 1; i >= start; --i) {
                int targetId = i == start + queueLength - 1 ? this.inputId : this.queueId + i + 1;
                int sourceId = this.queueId + i;
                ItemStack target = this.table.func_70301_a(targetId);
                ItemStack source = this.table.func_70301_a(sourceId);
                if (source == null) continue;
                ItemStack move = source.func_77946_l();
                move.field_77994_a = 1;
                if (!this.canMove(move, target)) continue;
                if (target == null) {
                    this.table.func_70299_a(targetId, move);
                } else {
                    ++target.field_77994_a;
                }
                --source.field_77994_a;
                if (source.field_77994_a != 0) continue;
                this.table.func_70299_a(sourceId, null);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
    }

    @Override
    protected ItemStack getProductionResult() {
        ArrayList<MachineRecipeInput> inputs = new ArrayList<MachineRecipeInput>();
        for (int i = 0; i < this.inputSize; ++i) {
            ItemStack stack = this.table.func_70301_a(i + this.inputId);
            if (!this.isItemStackValid(stack)) continue;
            inputs.add(new MachineRecipeInput(i, stack));
        }
        IRecipe ir = AlloyRecipeManager.getInstance().getRecipeForInputs(inputs.toArray(new MachineRecipeInput[0]));
        return inputs == null ? null : (ir == null ? null : ir.getOutputs()[0].getOutput());
    }

    private boolean isItemStackValid(ItemStack in) {
        return in != null && in.func_77973_b() != null;
    }

    @Override
    protected void onProduction(ItemStack result) {
        ArrayList<MachineRecipeInput> inputs = new ArrayList<MachineRecipeInput>();
        for (int i = 0; i < this.inputSize; ++i) {
            ItemStack stack = this.table.func_70301_a(i + this.inputId);
            if (!this.isItemStackValid(stack)) continue;
            inputs.add(new MachineRecipeInput(i, stack));
        }
        IRecipe ir = AlloyRecipeManager.getInstance().getRecipeForInputs(inputs.toArray(new MachineRecipeInput[0]));
        List stacks = ir.getInputStacks();
        block1: for (ItemStack stack : stacks) {
            for (int i = 0; i < 3; ++i) {
                ItemStack tableStack = this.table.func_70301_a(this.inputId + i);
                if (tableStack == null || tableStack.func_77973_b() != stack.func_77973_b()) continue;
                tableStack.field_77994_a -= stack.field_77994_a;
                continue block1;
            }
        }
    }

    @Override
    public int getOutputId() {
        return this.outputId;
    }

    @Override
    public boolean isEnabled() {
        ItemStack item = this.table.getUpgradePage().getUpgradeMainItem(this.id);
        return item != null && Upgrade.ParentType.ALLOY.isValidParent(item);
    }

    @Override
    public int getArrowX() {
        return 50;
    }

    @Override
    public int getArrowY() {
        return 24;
    }
}

