/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.container;

import engineers.workshop.client.container.ContainerBase;
import engineers.workshop.client.container.slot.SlotBase;
import engineers.workshop.client.container.slot.SlotPlayer;
import engineers.workshop.common.table.TileTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTable
extends ContainerBase {
    private TileTable table;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_PER_ROW = 9;
    private static final int NORMAL_ROWS = 3;
    private static final int PLAYER_X = 48;
    private static final int PLAYER_Y = 174;
    private static final int PLAYER_HOT_BAR_Y = 232;

    public ContainerTable(TileTable table, EntityPlayer player) {
        this.table = table;
        table.getSlots().forEach(this::func_75146_a);
        InventoryPlayer inventory = player.field_71071_by;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotPlayer((IInventory)inventory, table, x + y * 9 + 9, 48 + x * 18, y * 18 + 174));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotPlayer((IInventory)inventory, table, x, 48 + x * 18, 232));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.table.func_70300_a(player);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack itemstack = null;
        SlotBase slot = (SlotBase)((Object)this.field_75151_b.get(i));
        if (slot != null && slot.func_75216_d() && slot.isVisible()) {
            ItemStack slotItem = slot.func_75211_c();
            itemstack = slotItem.func_77946_l();
            if (i < this.table.func_70302_i_() ? !this.func_75135_a(slotItem, this.table.func_70302_i_() + 28, this.table.func_70302_i_() + 36, false) && !this.func_75135_a(slotItem, this.table.func_70302_i_(), this.table.func_70302_i_() + 28, false) : !this.func_75135_a(slotItem, 0, this.table.func_70302_i_(), false)) {
                return null;
            }
            if (slotItem.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotItem.field_77994_a != itemstack.field_77994_a) {
                slot.func_82870_a(player, slotItem);
            } else {
                return null;
            }
        }
        return itemstack;
    }

    @Override
    protected boolean func_75135_a(ItemStack item, int start, int end, boolean invert) {
        ItemStack slotItem;
        SlotBase slot;
        boolean result = false;
        int id = start;
        if (invert) {
            id = end - 1;
        }
        if (item.func_77985_e()) {
            while (item.field_77994_a > 0 && (!invert && id < end || invert && id >= start)) {
                slot = (SlotBase)((Object)this.field_75151_b.get(id));
                if (slot.isVisible() && slot.canShiftClickInto(item) && (slotItem = slot.func_75211_c()) != null && slotItem.field_77994_a > 0 && slotItem.func_77973_b() == item.func_77973_b() && (!item.func_77981_g() || item.func_77952_i() == slotItem.func_77952_i()) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)slotItem)) {
                    int size = slotItem.field_77994_a + item.field_77994_a;
                    int maxLimit = Math.min(item.func_77976_d(), slot.getSlotStackLimit(item));
                    if (size <= maxLimit) {
                        item.field_77994_a = 0;
                        slotItem.field_77994_a = size;
                        slot.func_75218_e();
                        result = true;
                    } else if (slotItem.field_77994_a < maxLimit) {
                        item.field_77994_a -= maxLimit - slotItem.field_77994_a;
                        slotItem.field_77994_a = maxLimit;
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (invert) {
                    --id;
                    continue;
                }
                ++id;
            }
        }
        if (item.field_77994_a > 0) {
            id = invert ? end - 1 : start;
            while (!invert && id < end || invert && id >= start) {
                int stackLimit;
                slot = (SlotBase)((Object)this.field_75151_b.get(id));
                slotItem = slot.func_75211_c();
                if (slot.isVisible() && slot.canShiftClickInto(item) && slotItem == null && slot.func_75214_a(item) && (stackLimit = slot.getSlotStackLimit(item)) > 0) {
                    int stackSize = Math.min(stackLimit, item.field_77994_a);
                    ItemStack newItem = item.func_77946_l();
                    newItem.field_77994_a = stackSize;
                    item.field_77994_a -= stackSize;
                    slot.func_75215_d(newItem);
                    slot.func_75218_e();
                    result = item.field_77994_a == 0;
                    break;
                }
                if (invert) {
                    --id;
                    continue;
                }
                ++id;
            }
        }
        return result;
    }

    @Override
    protected int getSlotStackLimit(Slot slot, ItemStack item) {
        return ((SlotBase)slot).getSlotStackLimit(item);
    }

    @Override
    public boolean canItemBePickedUpByDoubleClick(ItemStack item, Slot slot) {
        return ((SlotBase)slot).canPickUpOnDoubleClick();
    }

    @Override
    public boolean func_94531_b(Slot slot) {
        return ((SlotBase)slot).canDragIntoSlot();
    }

    public TileTable getTable() {
        return this.table;
    }
}

