/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.container;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ContainerBase
extends Container {
    @SideOnly(value=Side.CLIENT)
    private short transactionID;
    private int dragMouseButton = -1;
    private int dragMode;
    private final Set<Slot> draggedSlots = new HashSet<Slot>();
    private Set<EntityPlayer> invalidPlayers = new HashSet<EntityPlayer>();
    private static final int MOUSE_LEFT_CLICK = 0;
    private static final int MOUSE_RIGHT_CLICK = 1;
    private static final int FAKE_SLOT_ID = -999;
    private static final int CLICK_MODE_NORMAL = 0;
    private static final int CLICK_MODE_SHIFT = 1;
    private static final int CLICK_MODE_KEY = 2;
    private static final int CLICK_MODE_PICK_ITEM = 3;
    private static final int CLICK_MODE_OUTSIDE = 4;
    private static final int CLICK_DRAG_RELEASE = 5;
    private static final int CLICK_MODE_DOUBLE_CLICK = 6;
    private static final int CLICK_DRAG_MODE_PRE = 0;
    private static final int CLICK_DRAG_MODE_SLOT = 1;
    private static final int CLICK_DRAG_MODE_POST = 2;

    private List<ItemStack> getItems() {
        return this.field_75153_a;
    }

    private List<Slot> getSlots() {
        return this.field_75151_b;
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75222_d = this.field_75151_b.size();
        this.getSlots().add(slot);
        this.getItems().add(null);
        return slot;
    }

    public List<ItemStack> func_75138_a() {
        List<ItemStack> result = this.getSlots().stream().map(Slot::func_75211_c).collect(Collectors.toList());
        return result;
    }

    public boolean func_75140_a(EntityPlayer player, int slotId) {
        return false;
    }

    public Slot func_75139_a(int slotId) {
        return this.getSlots().get(slotId);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        return null;
    }

    public static boolean canItemBePickedUp(Slot slot, ItemStack playerItem, boolean partiallyMove) {
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItem = slot.func_75211_c();
            if (playerItem != null && playerItem.func_77969_a(slotItem) && ItemStack.func_77970_a((ItemStack)slotItem, (ItemStack)playerItem)) {
                int moveSize = partiallyMove ? 0 : playerItem.field_77994_a;
                return slot.func_75211_c().field_77994_a + moveSize <= playerItem.func_77976_d();
            }
            return false;
        }
        return true;
    }

    protected boolean canItemBePickedUpByDoubleClick(ItemStack itemStack, Slot slot) {
        return true;
    }

    public void func_75130_a(IInventory inventory) {
        this.func_75142_b();
    }

    public void func_75141_a(int slotId, ItemStack item) {
        this.func_75139_a(slotId).func_75215_d(item);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75131_a(ItemStack[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.func_75141_a(i, items[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
    }

    @SideOnly(value=Side.CLIENT)
    public short func_75136_a(InventoryPlayer inventory) {
        this.transactionID = (short)(this.transactionID + 1);
        return this.transactionID;
    }

    protected boolean isPlayerValid(EntityPlayer player) {
        return !this.invalidPlayers.contains(player);
    }

    protected void setValidState(EntityPlayer player, boolean valid) {
        if (valid) {
            this.invalidPlayers.remove(player);
        } else {
            this.invalidPlayers.add(player);
        }
    }

    public abstract boolean func_75145_c(EntityPlayer var1);

    protected boolean func_75135_a(ItemStack item, int start, int end, boolean invert) {
        ItemStack slotItem;
        Slot slot;
        boolean moved = false;
        int index = start;
        if (invert) {
            index = end - 1;
        }
        if (item.func_77985_e()) {
            while (item.field_77994_a > 0 && (!invert && index < end || invert && index >= start)) {
                slot = this.func_75139_a(index);
                slotItem = slot.func_75211_c();
                if (slotItem != null && slotItem.func_77973_b() == item.func_77973_b() && (!item.func_77981_g() || item.func_77952_i() == slotItem.func_77952_i()) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)slotItem)) {
                    int newSize = slotItem.field_77994_a + item.field_77994_a;
                    if (newSize <= item.func_77976_d()) {
                        item.field_77994_a = 0;
                        slotItem.field_77994_a = newSize;
                        slot.func_75218_e();
                        moved = true;
                    } else if (slotItem.field_77994_a < item.func_77976_d()) {
                        item.field_77994_a -= item.func_77976_d() - slotItem.field_77994_a;
                        slotItem.field_77994_a = item.func_77976_d();
                        slot.func_75218_e();
                        moved = true;
                    }
                }
                index += invert ? -1 : 1;
            }
        }
        if (item.field_77994_a > 0) {
            for (index = invert ? end - 1 : start; !invert && index < end || invert && index >= start; index += invert ? -1 : 1) {
                slot = this.func_75139_a(index);
                slotItem = slot.func_75211_c();
                if (slotItem != null) continue;
                slot.func_75215_d(item.func_77946_l());
                slot.func_75218_e();
                item.field_77994_a = 0;
                moved = true;
                break;
            }
        }
        return moved;
    }

    protected void resetDragging() {
        this.dragMode = 0;
        this.draggedSlots.clear();
    }

    public boolean func_94531_b(Slot slot) {
        return true;
    }

    protected int getSlotStackLimit(Slot slot, ItemStack itemStack) {
        return slot.func_75219_a();
    }
}

