/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.multipart.TMultiPart;
import java.util.UUID;
import mrtjp.core.inventory.InvWrapper$;
import mrtjp.core.item.ItemKey;
import mrtjp.core.item.ItemKeyStack;
import mrtjp.core.item.ItemKeyStack$;
import mrtjp.core.item.ItemQueue;
import mrtjp.core.world.Messenger$;
import mrtjp.projectred.core.Configurator$;
import mrtjp.projectred.core.TCenterAcquisitions;
import mrtjp.projectred.core.TSwitchPacket;
import mrtjp.projectred.transportation.AbstractPipePayload$;
import mrtjp.projectred.transportation.IRouterContainer;
import mrtjp.projectred.transportation.ItemRouterUtility;
import mrtjp.projectred.transportation.LSPathFinder$;
import mrtjp.projectred.transportation.LogisticPathFinder$;
import mrtjp.projectred.transportation.NetworkEvent;
import mrtjp.projectred.transportation.NetworkPayload;
import mrtjp.projectred.transportation.PayloadArrivedEvent;
import mrtjp.projectred.transportation.PayloadDepartedEvent;
import mrtjp.projectred.transportation.PayloadLostEnrouteEvent;
import mrtjp.projectred.transportation.PayloadPipePart;
import mrtjp.projectred.transportation.PayloadResolution;
import mrtjp.projectred.transportation.PipeDefs$;
import mrtjp.projectred.transportation.Priorities;
import mrtjp.projectred.transportation.Priorities$;
import mrtjp.projectred.transportation.RecievePayload;
import mrtjp.projectred.transportation.RelayPayload;
import mrtjp.projectred.transportation.RouteFX2$;
import mrtjp.projectred.transportation.RoutePayload;
import mrtjp.projectred.transportation.Router;
import mrtjp.projectred.transportation.RouterServices$;
import mrtjp.projectred.transportation.StartEndPath;
import mrtjp.projectred.transportation.SyncResponse;
import mrtjp.projectred.transportation.TNetworkPipe;
import mrtjp.projectred.transportation.TNetworkPipe$;
import mrtjp.projectred.transportation.TNetworkSubsystem;
import mrtjp.projectred.transportation.UnresolvedPayload;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public abstract class TNetworkPipe$class {
    public static void save(TNetworkPipe $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$save(tag);
        tag.func_74778_a("rid", TNetworkPipe$class.getRouterId($this).toString());
        tag.func_74768_a("sent", $this.statsSent());
        tag.func_74768_a("rec", $this.statsReceived());
        tag.func_74768_a("relay", $this.statsRelayed());
    }

    public static void load(TNetworkPipe $this, NBTTagCompound tag) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$load(tag);
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.routerId_$eq(UUID.fromString(tag.func_74779_i("rid")));
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            $this.statsSent_$eq(tag.func_74762_e("sent"));
            $this.statsReceived_$eq(tag.func_74762_e("rec"));
            $this.statsRelayed_$eq(tag.func_74762_e("relay"));
            return;
        }
    }

    public static void writeDesc(TNetworkPipe $this, MCDataOutput packet) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$writeDesc(packet);
        packet.writeByte((int)$this.linkMap());
        packet.writeLong(TNetworkPipe$class.getRouterId($this).getMostSignificantBits());
        packet.writeLong(TNetworkPipe$class.getRouterId($this).getLeastSignificantBits());
    }

    public static void readDesc(TNetworkPipe $this, MCDataInput packet) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$readDesc(packet);
        $this.linkMap_$eq(packet.readByte());
        long mostSigBits = packet.readLong();
        long leastSigBits = packet.readLong();
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.routerId_$eq(new UUID(mostSigBits, leastSigBits));
            return;
        }
    }

    public static void read(TNetworkPipe $this, MCDataInput packet, int key) {
        int n = key;
        switch (n) {
            default: {
                $this.mrtjp$projectred$transportation$TNetworkPipe$$super$read(packet, key);
                break;
            }
            case 5: {
                TNetworkPipe$class.handleLinkMap($this, packet);
            }
        }
    }

    public static void sendLinkMapUpdate(TNetworkPipe $this) {
        ((TSwitchPacket)$this).getWriteStreamOf(5).writeByte((int)$this.linkMap());
    }

    private static void handleLinkMap(TNetworkPipe $this, MCDataInput packet) {
        byte old = $this.linkMap();
        $this.linkMap_$eq(packet.readByte());
        int high = ~old & $this.linkMap();
        int low = ~$this.linkMap() & old;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this, high, low){
            private final /* synthetic */ TNetworkPipe $outer;
            private final int high$1;
            private final int low$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                if ((this.high$1 & 1 << i) != 0) {
                    RouteFX2$.MODULE$.spawnType3(RouteFX2$.MODULE$.color_linked(), i, this.$outer);
                }
                if ((this.low$1 & 1 << i) != 0) {
                    RouteFX2$.MODULE$.spawnType2(RouteFX2$.MODULE$.color_unlinked(), i, this.$outer);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.high$1 = high$1;
                this.low$1 = low$1;
            }
        });
        ((TMultiPart)$this).tile().markRender();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UUID getRouterId(TNetworkPipe $this) {
        BoxedUnit boxedUnit;
        if ($this.routerId() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return $this.routerId();
        }
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.routerId_$eq($this.router() == null ? UUID.randomUUID() : $this.router().getID());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit2;
            return $this.routerId();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Router getRouter(TNetworkPipe $this) {
        BoxedUnit boxedUnit;
        if ($this.router() != null) {
            boxedUnit = BoxedUnit.UNIT;
            return $this.router();
        }
        Object object = $this.routerIDLock();
        synchronized (object) {
            $this.router_$eq(RouterServices$.MODULE$.getOrCreateRouter(TNetworkPipe$class.getRouterId($this), $this));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : object
            boxedUnit = boxedUnit2;
            return $this.router();
        }
    }

    public static int countInTransit(TNetworkPipe $this, ItemKey key) {
        return $this.transitQueue().apply(key);
    }

    private static void dispatchQueuedPayload(TNetworkPipe $this, NetworkPayload r) {
        $this.injectPayload(r, r.input());
        Router dest = RouterServices$.MODULE$.getRouter(r.destinationIP());
        if (dest != null) {
            IRouterContainer wr = dest.getContainer();
            wr.postNetworkEvent(new PayloadDepartedEvent(r.payload().key(), r.payload().stackSize(), $this));
            RouteFX2$.MODULE$.spawnType1(RouteFX2$.MODULE$.color_sync(), $this);
        }
        RouteFX2$.MODULE$.spawnType1(RouteFX2$.MODULE$.color_send(), $this);
        $this.statsSent_$eq($this.statsSent() + 1);
    }

    public static final void update(TNetworkPipe $this) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$update();
        if (!((TMultiPart)$this).world().field_72995_K) {
            $this.getRouter().update(((TMultiPart)$this).world().func_82737_E());
        }
        if ($this.sendQueue().nonEmpty()) {
            NetworkPayload out = (NetworkPayload)$this.sendQueue().head();
            $this.sendQueue_$eq((Seq<NetworkPayload>)((Seq)$this.sendQueue().tail()));
            TNetworkPipe$class.dispatchQueuedPayload($this, out);
        }
        if (((TMultiPart)$this).world().field_72995_K) {
            $this.updateClient();
        } else {
            $this.updateServer();
        }
    }

    public static void updateServer(TNetworkPipe $this) {
    }

    public static void updateClient(TNetworkPipe $this) {
        if (((TMultiPart)$this).world().func_82737_E() % (long)(Configurator$.MODULE$.detectionFrequency() * 10) == (long)$this.searchDelay()) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this){
                private final /* synthetic */ TNetworkPipe $outer;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    if ((this.$outer.linkMap() & 1 << i) != 0) {
                        RouteFX2$.MODULE$.spawnType3(RouteFX2$.MODULE$.color_blink(), i, this.$outer);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public static void refreshState(TNetworkPipe $this, int sideMask) {
        if (((TMultiPart)$this).world().field_72995_K) {
            return;
        }
        if ($this.linkMap() != sideMask) {
            $this.linkMap_$eq((byte)sideMask);
            $this.sendLinkMapUpdate();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Vector searchForLinks(TNetworkPipe $this) {
        void var1_1;
        LSPathFinder$.MODULE$.clear();
        LSPathFinder$.MODULE$.start_$eq($this);
        Vector<StartEndPath> newAdjacent = LSPathFinder$.MODULE$.result();
        LSPathFinder$.MODULE$.clear();
        return var1_1;
    }

    public static TNetworkPipe getPipe(TNetworkPipe $this) {
        return $this;
    }

    public static void onRemoved(TNetworkPipe $this) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$onRemoved();
        TNetworkPipe$.MODULE$.delayDelta_$eq(package$.MODULE$.max(TNetworkPipe$.MODULE$.delayDelta() - 1, 0));
        Router r = $this.getRouter();
        if (r != null) {
            r.decommision();
        }
    }

    public static boolean activate(TNetworkPipe $this, EntityPlayer player, CuboidRayTraceResult hit, ItemStack item, EnumHand hand) {
        if ($this.mrtjp$projectred$transportation$TNetworkPipe$$super$activate(player, hit, item, hand)) {
            return true;
        }
        if (item != null && item.func_77973_b() instanceof ItemRouterUtility) {
            if (!((TMultiPart)$this).world().field_72995_K) {
                String s = new StringBuilder().append((Object)"/#fR").append((Object)BoxesRunTime.boxToInteger((int)$this.getRouter().getIPAddress())).append((Object)" route statistics: ").append((Object)"\nreceived: ").append((Object)BoxesRunTime.boxToInteger((int)$this.statsReceived())).append((Object)"\nsent: ").append((Object)BoxesRunTime.boxToInteger((int)$this.statsSent())).append((Object)"\nrelayed: ").append((Object)BoxesRunTime.boxToInteger((int)$this.statsRelayed())).append((Object)"\n\nroute table size: ").append($this.getRouter().getRouteTable().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable($this){

                    public final int apply(int b, Vector<StartEndPath> v) {
                        return v == null ? b : b + 1;
                    }
                })).toString();
                PacketCustom packet = Messenger$.MODULE$.createPacket();
                packet.writeDouble((double)((TMultiPart)$this).x() + 0.0);
                packet.writeDouble((double)((TMultiPart)$this).y() + 0.5);
                packet.writeDouble((double)((TMultiPart)$this).z() + 0.0);
                packet.writeString(s);
                packet.sendToPlayer(player);
            }
            return true;
        }
        return false;
    }

    public static TextureAtlasSprite getIcon(TNetworkPipe $this, int side) {
        TextureAtlasSprite[] array = PipeDefs$.MODULE$.ROUTEDJUNCTION().sprites();
        int ind = side == $this.inOutSide() ? 2 : 0;
        return ($this.linkMap() & 1 << side) != 0 ? array[1 + ind] : array[2 + ind];
    }

    public static void resolveDestination(TNetworkPipe $this, NetworkPayload r) {
        PayloadResolution payloadResolution;
        block9: {
            int n;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            payloadResolution = $this.getRouter().resolvePayload(r);
                            if (!(payloadResolution instanceof RoutePayload)) break block5;
                            RoutePayload routePayload = (RoutePayload)payloadResolution;
                            int toDir = routePayload.toDir();
                            r.output_$eq(toDir);
                            n = RouteFX2$.MODULE$.color_route();
                            break block6;
                        }
                        if (!(payloadResolution instanceof RelayPayload)) break block7;
                        RelayPayload relayPayload = (RelayPayload)payloadResolution;
                        int toDir = relayPayload.toDir();
                        r.output_$eq(toDir);
                        n = RouteFX2$.MODULE$.color_relay();
                        break block6;
                    }
                    if (!(payloadResolution instanceof RecievePayload)) break block8;
                    r.output_$eq($this.getDirForIncomingItem(r));
                    if (r.output() != 6) {
                        $this.postNetworkEvent(new PayloadArrivedEvent(r.payload().key(), r.payload().stackSize()));
                    }
                    n = RouteFX2$.MODULE$.color_receive();
                    break block6;
                }
                if (!(payloadResolution instanceof UnresolvedPayload)) break block9;
                r.output_$eq(6);
                n = RouteFX2$.MODULE$.color_routeLost();
            }
            int colour = n;
            if (r.output() == 6) {
                r.resetTrip();
                IntRef m = IntRef.create((int)0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)new Serializable($this, m){
                    private final /* synthetic */ TNetworkPipe $outer;
                    private final IntRef m$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        if (((TCenterAcquisitions)this.$outer).getStraight(i) instanceof TNetworkSubsystem) {
                            this.m$1.elem |= 1 << i;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.m$1 = m$1;
                    }
                });
                ((PayloadPipePart)((Object)$this)).chooseRandomDestination(r, ~m.elem);
                colour = RouteFX2$.MODULE$.color_routeLost();
            }
            $this.adjustSpeed(r);
            RouteFX2$.MODULE$.spawnType1(colour, $this);
            return;
        }
        throw new MatchError((Object)payloadResolution);
    }

    public static void injectPayload(TNetworkPipe $this, NetworkPayload r, int in) {
        $this.mrtjp$projectred$transportation$TNetworkPipe$$super$injectPayload(r, in);
        Priorities.Priority priority = r.netPriority();
        Priorities.Priority priority2 = Priorities$.MODULE$.WANDERING();
        if (!(priority != null ? !((Object)priority).equals(priority2) : priority2 != null)) {
            r.tickPayloadWander();
        }
    }

    public static int getDirForIncomingItem(TNetworkPipe $this, NetworkPayload r) {
        return $this.inOutSide();
    }

    public static void adjustSpeed(TNetworkPipe $this, NetworkPayload r) {
        r.speed_$eq(r.netPriority().boost());
    }

    public static void postNetworkEvent(TNetworkPipe $this, NetworkEvent event) {
        NetworkEvent networkEvent = event;
        if (networkEvent instanceof PayloadDepartedEvent) {
            PayloadDepartedEvent payloadDepartedEvent = (PayloadDepartedEvent)networkEvent;
            $this.transitQueue().add(payloadDepartedEvent.item(), payloadDepartedEvent.amount());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (networkEvent instanceof PayloadArrivedEvent) {
            PayloadArrivedEvent payloadArrivedEvent = (PayloadArrivedEvent)networkEvent;
            $this.transitQueue().remove(payloadArrivedEvent.item(), payloadArrivedEvent.amount());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (networkEvent instanceof PayloadLostEnrouteEvent) {
            PayloadLostEnrouteEvent payloadLostEnrouteEvent = (PayloadLostEnrouteEvent)networkEvent;
            $this.transitQueue().remove(payloadLostEnrouteEvent.item(), payloadLostEnrouteEvent.amount());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static SyncResponse getSyncResponse(TNetworkPipe $this, ItemKey item, SyncResponse rival) {
        return null;
    }

    public static void queueStackToSend(TNetworkPipe $this, ItemKey item, int amount, Priorities.Priority priority, int destination) {
        ItemKeyStack stack2 = ItemKeyStack$.MODULE$.get(item, amount);
        NetworkPayload r = new NetworkPayload(AbstractPipePayload$.MODULE$.claimID());
        r.payload_$eq(stack2);
        r.input_$eq($this.getInterfacedSide());
        r.setDestination(destination, priority);
        $this.sendQueue_$eq((Seq<NetworkPayload>)((Seq)$this.sendQueue().$colon$plus((Object)r, Seq$.MODULE$.canBuildFrom())));
    }

    public static SyncResponse getLogisticPath(TNetworkPipe $this, ItemKey item, BitSet exclusions, boolean excludeStart) {
        LogisticPathFinder$.MODULE$.clear();
        LogisticPathFinder$.MODULE$.start_$eq($this.getRouter());
        LogisticPathFinder$.MODULE$.payload_$eq(item);
        LogisticPathFinder$.MODULE$.exclusions_$eq(exclusions);
        LogisticPathFinder$.MODULE$.excludeSource_$eq(excludeStart);
        SyncResponse result2 = LogisticPathFinder$.MODULE$.result();
        LogisticPathFinder$.MODULE$.clear();
        return result2;
    }

    public static World getWorld(TNetworkPipe $this) {
        return ((TMultiPart)$this).world();
    }

    public static int getActiveFreeSpace(TNetworkPipe $this, ItemKey item) {
        IInventory real = $this.getInventory();
        return real == null ? 0 : InvWrapper$.MODULE$.wrap(real).setSlotsFromSide($this.getInterfacedSide()).getSpaceForItem(item);
    }

    public static void $init$(TNetworkPipe $this) {
        TNetworkPipe$.MODULE$.delayDelta_$eq(TNetworkPipe$.MODULE$.delayDelta() + 1);
        $this.mrtjp$projectred$transportation$TNetworkPipe$_setter_$searchDelay_$eq(TNetworkPipe$.MODULE$.delayDelta() % Configurator$.MODULE$.detectionFrequency());
        $this.linkMap_$eq((byte)0);
        $this.router_$eq(null);
        $this.routerId_$eq(null);
        $this.mrtjp$projectred$transportation$TNetworkPipe$_setter_$routerIDLock_$eq(new Object());
        $this.sendQueue_$eq((Seq<NetworkPayload>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        $this.transitQueue_$eq(new ItemQueue());
        $this.statsReceived_$eq(0);
        $this.statsSent_$eq(0);
        $this.statsRelayed_$eq(0);
    }
}

