/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.etlunar.core;

import com.valkyrieofnight.environmentaltech.multiblock.structure.components.ETComponents;
import com.valkyrieofnight.etlunar.init.ETLRecipes;
import com.valkyrieofnight.etlunar.multiblock.structure.components.ETLComponents;
import com.valkyrieofnight.etlunar.tile.lunarpanel.ContLunarCustom;
import com.valkyrieofnight.etlunar.tile.lunarpanel.TileLunarPanelBase;
import com.valkyrieofnight.valkyrielib.core.IInitMod;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ETLConfig
implements IInitMod {
    private static ETLConfig instance;
    private Configuration machines;
    private int tierStructures = 1;
    private int modSlots = 1;

    public static ETLConfig getInstance() {
        if (instance == null) {
            instance = new ETLConfig();
        }
        return instance;
    }

    private ETLConfig() {
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.loadMachinesConfig(event);
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    private void loadMachinesConfig(FMLPreInitializationEvent event) {
        File mcfg = new File(event.getModConfigurationDirectory(), "etlunar/machines.cfg");
        this.machines = new Configuration(mcfg);
        if (mcfg.exists()) {
            this.machines.load();
        }
        ETLRecipes.enableRecipes = this.machines.getBoolean("enableRecipes", "LunarPanel", ETLRecipes.enableRecipes, "Enable recipes for the lunar panel");
        ContLunarCustom.PANEL_TIER = this.oddNum(this.machines.getInt("customLunarPanelTier", "LunarPanel", ContLunarCustom.PANEL_TIER, 1, 15, "This is the tier of the lunar panel. Size will be calculated off this number"));
        TileLunarPanelBase.PRODUCTION_RATE = this.machines.getInt("rfPerCellT1", "LunarPanel", TileLunarPanelBase.PRODUCTION_RATE, 8, 1024, "Base Rate for a T1 Lunar Panel.");
        this.tierStructures = this.machines.getInt("customLunarPanelStructureRequirement", "LunarPanel", this.tierStructures, 1, 4, "Structure tier to be used for this multiblock");
        this.modSlots = this.machines.getInt("customLunarPanelModSlots", "LunarPanel", this.modSlots, 0, 4, "Mod Slots avaliable for the custom lunar panel. Number * 4 = total modifier slots.");
        this.setupCustomPanel();
        if (!mcfg.exists() || this.machines.hasChanged()) {
            this.machines.save();
        }
    }

    private void setupCustomPanel() {
        int panelHalf = ContLunarCustom.PANEL_TIER + 1;
        for (int x = -panelHalf; x < panelHalf + 1; ++x) {
            for (int z = -panelHalf; z < panelHalf + 1; ++z) {
                if (x == -panelHalf || z == -panelHalf || x == panelHalf || z == panelHalf) {
                    switch (this.tierStructures) {
                        case 1: {
                            ContLunarCustom.mb.addRequiredBlock(ETComponents.STRUCTURE_T1, x, 1, z);
                            break;
                        }
                        case 2: {
                            ContLunarCustom.mb.addRequiredBlock(ETComponents.STRUCTURE_T2, x, 1, z);
                            break;
                        }
                        case 3: {
                            ContLunarCustom.mb.addRequiredBlock(ETComponents.STRUCTURE_T3, x, 1, z);
                            break;
                        }
                        default: {
                            ContLunarCustom.mb.addRequiredBlock(ETComponents.STRUCTURE_T4, x, 1, z);
                            break;
                        }
                    }
                    continue;
                }
                ContLunarCustom.mb.addRequiredBlock(ETLComponents.LUNAR_CELL, x, 1, z);
            }
        }
        switch (this.modSlots) {
            case 0: {
                break;
            }
            case 1: {
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 1, 0, 1);
                break;
            }
            case 2: {
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 2, 0, 1);
                break;
            }
            case 3: {
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 1, 0, 1);
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 2, 0, 1);
                break;
            }
            default: {
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 1, 0, 1);
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 2, 0, 1);
                ContLunarCustom.mb.addOffsetReqCompSymmetrical(ETComponents.MODIFIER, 2, 0, 2);
            }
        }
    }

    private int oddNum(int num) {
        if (num % 2 == 1) {
            return num;
        }
        return num++;
    }
}

