/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.infinityraider.agricraft.reference.AgriNuggetType;
import com.infinityraider.agricraft.utility.StackHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictHelper {
    private static final Map<String, Block> oreBlocks = new HashMap<String, Block>();
    private static final Map<String, Integer> oreBlockMeta = new HashMap<String, Integer>();

    public static Block getOreBlockForName(String name) {
        return oreBlocks.get(name);
    }

    public static int getOreMetaForName(String name) {
        return oreBlockMeta.get(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasOreId(ItemStack stack, String tag) {
        if (!StackHelper.isValid(stack)) return false;
        if (!OreDictHelper.getOreNames(stack).anyMatch(tag::equals)) return false;
        return true;
    }

    public static IntStream getOreIds(ItemStack stack) {
        return Arrays.stream(OreDictionary.getOreIDs((ItemStack)stack));
    }

    public static Stream<String> getOreNames(ItemStack stack) {
        return OreDictHelper.getOreIds(stack).mapToObj(OreDictionary::getOreName);
    }

    public static boolean hasOreId(Block block, String tag) {
        return block != null && OreDictHelper.hasOreId(new ItemStack(block), tag);
    }

    public static boolean isSameOre(Block block1, int meta1, Block block2, int meta2) {
        if (block1 == block2 && meta1 == meta2) {
            return true;
        }
        if (block1 == null || block2 == null) {
            return false;
        }
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)new ItemStack(block1, 1, meta1));
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)new ItemStack(block2, 1, meta2));
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getIngot(String ingotName) {
        return OreDictionary.getOres((String)ingotName).stream().findAny().orElse(null);
    }

    private static void getOreBlock(AgriNuggetType type) {
        for (ItemStack itemStack : OreDictionary.getOres((String)type.ore)) {
            if (!(itemStack.func_77973_b() instanceof ItemBlock)) continue;
            ItemBlock block = (ItemBlock)itemStack.func_77973_b();
            oreBlocks.put(type.name(), block.field_150939_a);
            oreBlockMeta.put(type.name(), itemStack.func_77952_i());
            return;
        }
    }

    public static ArrayList<ItemStack> getFruitsFromOreDict(ItemStack seed) {
        return OreDictHelper.getFruitsFromOreDict(seed, true);
    }

    public static ArrayList<ItemStack> getFruitsFromOreDict(ItemStack seed, boolean sameMod) {
        String seedModId = OreDictHelper.getModId(seed);
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        for (int id : OreDictionary.getOreIDs((ItemStack)seed)) {
            if (!OreDictionary.getOreName((int)id).substring(0, 4).equalsIgnoreCase("seed")) continue;
            String name = OreDictionary.getOreName((int)id).substring(4);
            List fromOredict = OreDictionary.getOres((String)("crop" + name));
            for (ItemStack stack : fromOredict) {
                if (!StackHelper.isValid(stack)) continue;
                String stackModId = OreDictHelper.getModId(stack);
                if (sameMod && !stackModId.equals(seedModId)) continue;
                fruits.add(stack);
            }
        }
        return fruits;
    }

    private static String getModId(ItemStack stack) {
        String name = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).func_110623_a();
        int split = name.indexOf(58);
        if (split >= 0) {
            name = name.substring(0, split);
        }
        return name;
    }
}

