/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.agricraft.utility.NBTHelper;
import com.infinityraider.agricraft.utility.StackHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class CustomWoodTypeRegistry {
    public static final CustomWoodType DEFAULT = new CustomWoodType(Blocks.field_150344_f, 0);
    public static final FuzzyStack DEFAULT_STACK = new FuzzyStack(DEFAULT.getStack(), false, true, new String[0]);
    private static final Map<String, CustomWoodType> WOOD_TYPES = new HashMap<String, CustomWoodType>();

    public static void init() {
        CustomWoodTypeRegistry.init(block -> IntStream.range(0, 16));
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        CustomWoodTypeRegistry.init(block -> {
            ArrayList subItems = new ArrayList();
            block.func_150895_a((Item)block, block.func_77640_w(), subItems);
            return subItems.stream().mapToInt(ItemStack::func_77952_i);
        });
    }

    private static void init(Function<ItemBlock, IntStream> getItemDamages) {
        if (!WOOD_TYPES.isEmpty()) {
            return;
        }
        OreDictionary.getOres((String)"plankWood").stream().filter(plank -> plank.func_77973_b() instanceof ItemBlock).flatMap(plank -> {
            ItemBlock block = (ItemBlock)plank.func_77973_b();
            if (plank.func_77952_i() == Short.MAX_VALUE) {
                return ((IntStream)getItemDamages.apply(block)).mapToObj(meta -> new CustomWoodType(block.field_150939_a, meta));
            }
            return Stream.of(new CustomWoodType(block.field_150939_a, plank.func_77952_i()));
        }).forEach(type -> WOOD_TYPES.put(type.toString(), (CustomWoodType)type));
    }

    public static final Optional<CustomWoodType> getFromStack(ItemStack stack) {
        if (StackHelper.hasKey(stack, "agri_material", "agri_material_meta")) {
            return CustomWoodTypeRegistry.getFromNbt(stack.func_77978_p());
        }
        if (StackHelper.isValid(stack, ItemBlock.class)) {
            ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
            return CustomWoodTypeRegistry.getFromBlockAndMeta(itemBlock.func_179223_d(), itemBlock.getMetadata(stack));
        }
        return Optional.empty();
    }

    public static final Optional<CustomWoodType> getFromNbt(NBTTagCompound tag) {
        if (NBTHelper.hasKey(tag, "agri_material", "agri_material_meta")) {
            return CustomWoodTypeRegistry.getFromIdAndMeta(tag.func_74779_i("agri_material"), tag.func_74762_e("agri_material_meta"));
        }
        return Optional.empty();
    }

    public static final Optional<CustomWoodType> getFromBlockAndMeta(Block block, int meta) {
        return CustomWoodTypeRegistry.getFromIdAndMeta(block.getRegistryName().toString(), meta);
    }

    public static final Optional<CustomWoodType> getFromIdAndMeta(String id, int meta) {
        return Optional.ofNullable(WOOD_TYPES.get(id + ":" + meta));
    }

    public static final Collection<CustomWoodType> getAllTypes() {
        return WOOD_TYPES.values();
    }
}

