/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.irrigation.IrrigationConnectionType;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import net.minecraft.block.BlockLever;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChannelValve
extends TileEntityChannel
implements IDebuggable {
    private boolean powered = false;

    @Override
    protected final void writeChannelNBT(NBTTagCompound tag) {
        tag.func_74757_a("agri_power", this.powered);
    }

    @Override
    protected final void readChannelNBT(NBTTagCompound tag) {
        this.powered = tag.func_74767_n("agri_power");
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.powered) {
                super.func_73660_a();
            } else if (++this.ticksSinceNeighbourCheck > 1024) {
                this.checkConnections();
                this.ticksSinceNeighbourCheck = 0;
            }
        }
    }

    public void updatePowerStatus() {
        boolean wasPowered = this.powered;
        boolean bl = this.powered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        if (this.powered != wasPowered) {
            this.markForUpdate();
        }
    }

    @Override
    public IrrigationConnectionType getConnectionType(EnumFacing side) {
        if (WorldHelper.getBlock((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side), BlockLever.class).isPresent()) {
            return IrrigationConnectionType.AUXILIARY;
        }
        return super.getConnectionType(side);
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public boolean canAcceptFluid(int y, int amount, boolean partial) {
        return !this.powered && super.canAcceptFluid(y, amount, partial);
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("VALVE");
        consumer.accept("  - State: " + (this.isPowered() ? "closed" : "open"));
        consumer.accept("  - FluidLevel: " + this.getFluidAmount(0) + "/" + 500);
        consumer.accept("  - FluidHeight: " + this.getFluidHeight());
        consumer.accept("  - Material: " + this.getMaterialBlock().getRegistryName() + ":" + this.getMaterialMeta());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayInfo(Consumer<String> information) {
        super.addDisplayInfo(information);
        String status = AgriCore.getTranslator().translate(this.powered ? "agricraft_tooltip.closed" : "agricraft_tooltip.open");
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.state") + ": " + status);
    }
}

