/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.irrigation.IConnectable;
import com.infinityraider.agricraft.api.v1.irrigation.IIrrigationComponent;
import com.infinityraider.agricraft.api.v1.irrigation.IrrigationConnectionType;
import com.infinityraider.agricraft.network.MessageSyncFluidLevel;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannelValve;
import com.infinityraider.agricraft.tiles.irrigation.TileEntitySprinkler;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityTank;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChannel
extends TileEntityCustomWood
implements ITickable,
IIrrigationComponent,
IDebuggable {
    private final IIrrigationComponent[] neighbours = new IIrrigationComponent[4];
    protected static final int NEIGHBOUR_CHECK_DELAY = 1024;
    protected int ticksSinceNeighbourCheck = 1024;
    protected static final int MIN = 5;
    protected static final int MAX = 12;
    protected static final int HEIGHT = 7;
    protected static final int DISCRETE_MAX = 16;
    protected static final int ABSOLUTE_MAX = AgriCraftConfig.channelCapacity;
    protected static final float DISCRETE_FACTOR = 16.0f / (float)ABSOLUTE_MAX;
    private int lvl;
    private int lastDiscreteLvl = 0;

    @Override
    protected final void writeNBT(NBTTagCompound tag) {
        if (this.lvl > 0) {
            tag.func_74768_a("agri_level", this.lvl);
        }
        this.writeChannelNBT(tag);
    }

    void writeChannelNBT(NBTTagCompound tag) {
    }

    @Override
    protected final void readNBT(NBTTagCompound tag) {
        this.lvl = tag.func_74764_b("agri_level") ? tag.func_74762_e("agri_level") : 0;
        this.readChannelNBT(tag);
    }

    void readChannelNBT(NBTTagCompound tag) {
    }

    @Override
    public int getFluidAmount(int y) {
        return this.lvl;
    }

    @Override
    public int getCapacity() {
        return ABSOLUTE_MAX;
    }

    @Override
    public void setFluidLevel(int lvl) {
        if (lvl >= 0 && lvl <= ABSOLUTE_MAX && lvl != this.lvl) {
            this.lvl = lvl;
            this.syncFluidLevel();
        }
    }

    @Override
    public int acceptFluid(int y, int amount, boolean partial) {
        if (!this.field_145850_b.field_72995_K && amount >= 0 && this.canAcceptFluid(0, amount, partial)) {
            int room = this.getCapacity() - this.getFluidAmount(0);
            if (room >= amount) {
                this.setFluidLevel(this.getFluidAmount(0) + amount);
                amount = 0;
            } else if (room > 0) {
                this.setFluidLevel(this.getCapacity());
                amount -= room;
            }
        }
        return amount;
    }

    @Override
    public boolean canConnectTo(EnumFacing side, IConnectable component) {
        return component instanceof TileEntityCustomWood && this.isSameMaterial((TileEntityCustomWood)((Object)component));
    }

    @Override
    public boolean canAcceptFluid(int y, int amount, boolean partial) {
        if (this.lvl + amount >= this.getCapacity()) {
            return true;
        }
        return partial;
    }

    @Override
    public final void checkConnections() {
        for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
            EnumFacing dir = EnumFacing.field_176754_o[i];
            this.neighbours[i] = WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(dir), IIrrigationComponent.class).filter(n -> n.canConnectTo(dir.func_176734_d(), this) || this.canConnectTo(dir, (IConnectable)n)).orElse(null);
        }
    }

    @Override
    public int getFluidHeight() {
        return (int)this.getFluidHeight(this.getFluidAmount(0));
    }

    @Override
    public float getFluidHeight(int lvl) {
        return 5.0f + 7.0f * (float)lvl / (float)ABSOLUTE_MAX;
    }

    public boolean hasNeighbor(EnumFacing direction) {
        int dir = direction.func_176736_b();
        return dir >= 0 && this.neighbours[dir] != null;
    }

    public IIrrigationComponent getNeighbor(EnumFacing direction) {
        int dir = direction.func_176736_b();
        return dir >= 0 ? this.neighbours[dir] : null;
    }

    @Override
    public IrrigationConnectionType getConnectionType(EnumFacing side) {
        if (this.hasNeighbor(side)) {
            return IrrigationConnectionType.PRIMARY;
        }
        return IrrigationConnectionType.NONE;
    }

    public void func_73660_a() {
        if (++this.ticksSinceNeighbourCheck > 1024) {
            this.checkConnections();
            this.ticksSinceNeighbourCheck = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            int totalLvl = 0;
            int nr = 1;
            int updatedLevel = this.getFluidAmount(0);
            for (IIrrigationComponent component : this.neighbours) {
                if (component == null) continue;
                if (component instanceof TileEntityChannel) {
                    if (component instanceof TileEntityChannelValve && ((TileEntityChannelValve)component).isPowered()) continue;
                    totalLvl += ((TileEntityChannel)component).lvl;
                    ++nr;
                    continue;
                }
                TileEntityTank tank = (TileEntityTank)component;
                int Y = tank.getYPosition();
                float y_c = (float)(16 * Y) + this.getFluidHeight(updatedLevel);
                float y_t = tank.getFluidHeight();
                float y1 = 5.0f + (float)(16 * Y);
                float y2 = 12.0f + (float)(16 * Y);
                int V_tot = tank.getFluidAmount(0) + updatedLevel;
                if (y_c == y_t) continue;
                if (y_t <= y1) {
                    updatedLevel = 0;
                    tank.setFluidLevel(V_tot);
                    continue;
                }
                if (y_t >= y2) {
                    updatedLevel = ABSOLUTE_MAX;
                    tank.setFluidLevel(V_tot - ABSOLUTE_MAX);
                    continue;
                }
                int tankYSize = tank.getMultiBlockData().sizeY();
                int C = tank.getCapacity();
                float enumerator = (float)V_tot + ((float)ABSOLUTE_MAX * y1 / (y2 - y1) + 2.0f * (float)C / (float)(16 * tankYSize - 2));
                float denominator = (float)ABSOLUTE_MAX / (y2 - y1) + (float)C / (float)(16 * tankYSize - 2);
                float y = enumerator / denominator;
                int channelVolume = (int)Math.floor((float)ABSOLUTE_MAX * (y - y1) / (y2 - y1));
                int tankVolume = (int)Math.ceil((float)C * (y - 2.0f) / (float)(16 * tankYSize - 2));
                updatedLevel = channelVolume;
                tank.setFluidLevel(tankVolume);
            }
            TileEntitySprinkler spr = WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), TileEntitySprinkler.class).orElse(null);
            if (spr != null) {
                updatedLevel = spr.acceptFluid(1000, updatedLevel, true);
            }
            int rest = (totalLvl += updatedLevel) % nr;
            int newLvl = totalLvl / nr;
            if (nr > 1) {
                for (IIrrigationComponent component : this.neighbours) {
                    if (!(component instanceof TileEntityChannel) || component instanceof TileEntityChannelValve && ((TileEntityChannelValve)component).isPowered()) continue;
                    int olvl = rest == 0 ? newLvl : newLvl + 1;
                    rest = rest == 0 ? 0 : rest - 1;
                    component.setFluidLevel(olvl);
                }
            }
            this.setFluidLevel(newLvl + rest);
        }
    }

    @Override
    public void syncFluidLevel() {
        int newDiscreteLvl;
        if (!this.field_145850_b.field_72995_K && (newDiscreteLvl = this.getDiscreteFluidLevel()) != this.lastDiscreteLvl) {
            this.lastDiscreteLvl = newDiscreteLvl;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.xCoord(), (double)this.yCoord(), (double)this.zCoord(), 64.0);
            new MessageSyncFluidLevel(this.lvl, this.func_174877_v()).sendToAllAround(point);
        }
    }

    public int getDiscreteFluidLevel() {
        int discreteFluidLevel = Math.round(DISCRETE_FACTOR * (float)this.lvl);
        if (discreteFluidLevel == 0 && this.lvl > 0) {
            discreteFluidLevel = 1;
        }
        return discreteFluidLevel;
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("CHANNEL:");
        super.addServerDebugInfo(consumer);
        consumer.accept("  - FluidLevel: " + this.getFluidAmount(0) + "/" + ABSOLUTE_MAX);
        consumer.accept("  - FluidHeight: " + this.getFluidHeight());
        consumer.accept("  - Connections: ");
        for (EnumFacing dir : EnumFacing.values()) {
            if (!this.hasNeighbor(dir)) continue;
            consumer.accept("      - " + dir.name());
        }
    }

    public void addClientDebugInfo(Consumer<String> consumer) {
        consumer.accept("CHANNEL:");
        super.addClientDebugInfo(consumer);
        consumer.accept("  - FluidLevel: " + this.getFluidAmount(0) + "/" + ABSOLUTE_MAX);
        consumer.accept("  - FluidHeight: " + this.getFluidHeight());
        consumer.accept("  - Connections: ");
        for (EnumFacing dir : EnumFacing.values()) {
            if (!this.hasNeighbor(dir)) continue;
            consumer.accept("      - " + dir.name());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayInfo(Consumer<String> information) {
        super.addDisplayInfo(information);
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.waterLevel") + ": " + this.getFluidAmount(0) + "/" + ABSOLUTE_MAX);
    }

    protected IBlockState getStateChannel(IBlockState state) {
        return state;
    }
}

