/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.infinitylib.render.block.RenderBlockWithTileBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class RenderBlockCustomWood<B extends BlockCustomWood<T>, T extends TileEntityCustomWood>
extends RenderBlockWithTileBase<B, T> {
    protected RenderBlockCustomWood(B block, T te, boolean inventory, boolean staticRender, boolean dynRender) {
        super(block, te, inventory, staticRender, dynRender);
    }

    public void renderWorldBlockDynamic(ITessellator tessellator, World world, BlockPos pos, double x, double y, double z, B block, T tile, float partialTick, int destroyStage) {
        this.renderWorldBlockWoodDynamic(tessellator, world, pos, block, tile, this.getIcon((TileEntityCustomWood)tile));
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, B block, EnumFacing side) {
        if (state instanceof IExtendedBlockState) {
            CustomWoodType type = (CustomWoodType)((IExtendedBlockState)state).getValue(AgriProperties.CUSTOM_WOOD_TYPE);
            this.renderWorldBlockWoodStatic(tessellator, (IExtendedBlockState)state, block, side, type.getIcon());
        }
    }

    public final void renderInventoryBlock(ITessellator tessellator, World world, IBlockState state, B block, T tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        ((TileEntityCustomWood)tile).setMaterial(stack);
        this.renderInventoryBlockWood(tessellator, world, state, block, tile, stack, entity, type, this.getIcon((TileEntityCustomWood)tile));
    }

    protected abstract void renderWorldBlockWoodDynamic(ITessellator var1, World var2, BlockPos var3, B var4, T var5, TextureAtlasSprite var6);

    protected abstract void renderWorldBlockWoodStatic(ITessellator var1, IExtendedBlockState var2, B var3, EnumFacing var4, TextureAtlasSprite var5);

    protected abstract void renderInventoryBlockWood(ITessellator var1, World var2, IBlockState var3, B var4, T var5, ItemStack var6, EntityLivingBase var7, ItemCameraTransforms.TransformType var8, TextureAtlasSprite var9);

    public List<ResourceLocation> getAllTextures() {
        return Collections.emptyList();
    }

    public TextureAtlasSprite getIcon() {
        return this.getIcon((TileEntityCustomWood)this.getTileEntity());
    }

    @Nonnull
    public TextureAtlasSprite getIcon(TileEntityCustomWood tile) {
        if (tile == null) {
            return BaseIcons.OAK_PLANKS.getIcon();
        }
        return tile.getIcon();
    }
}

