/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.network;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.tiles.storage.SeedStorageSlot;
import com.infinityraider.agricraft.tiles.storage.TileEntitySeedStorage;
import com.infinityraider.infinitylib.network.MessageBase;
import com.infinityraider.infinitylib.network.serialization.ByteBufUtil;
import com.infinityraider.infinitylib.network.serialization.IMessageReader;
import com.infinityraider.infinitylib.network.serialization.IMessageSerializer;
import com.infinityraider.infinitylib.network.serialization.IMessageWriter;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageTileEntitySeedStorage
extends MessageBase<IMessage> {
    private BlockPos pos;
    private int slotId;
    private int amount;
    private IAgriStat stats;

    public MessageTileEntitySeedStorage() {
    }

    public MessageTileEntitySeedStorage(BlockPos pos, SeedStorageSlot slot) {
        this.pos = pos;
        if (slot != null) {
            this.slotId = slot.getId();
            this.amount = slot.count;
            this.stats = slot.getSeed().getStat();
        } else {
            this.slotId = -1;
        }
    }

    public Side getMessageHandlerSide() {
        return Side.CLIENT;
    }

    protected void processMessage(MessageContext ctx) {
        TileEntitySeedStorage storage;
        ItemStack stack;
        TileEntity te = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(this.pos);
        if (te instanceof TileEntitySeedStorage && (stack = (ItemStack)(storage = (TileEntitySeedStorage)te).getLockedSeed().map(s -> s.toStack()).orElse(null)) != null) {
            stack.field_77994_a = this.amount;
            NBTTagCompound tag = new NBTTagCompound();
            this.stats.writeToNBT(tag);
            stack.func_77982_d(tag);
            storage.setSlotContents(this.slotId, stack);
        }
    }

    protected IMessage getReply(MessageContext ctx) {
        return null;
    }

    protected List<IMessageSerializer> getNecessarySerializers() {
        return ImmutableList.of((Object)new IMessageSerializer<IAgriStat>(){

            public boolean accepts(Class<IAgriStat> clazz) {
                return IAgriStat.class.isAssignableFrom(clazz);
            }

            public IMessageWriter<IAgriStat> getWriter(Class<IAgriStat> clazz) {
                return (buf, data) -> {
                    NBTTagCompound tag = new NBTTagCompound();
                    data.writeToNBT(tag);
                    ByteBufUtil.writeNBT((ByteBuf)buf, (NBTTagCompound)tag);
                };
            }

            public IMessageReader<IAgriStat> getReader(Class<IAgriStat> clazz) {
                return buf -> AgriApi.getStatRegistry().valueOf(ByteBufUtil.readNBT((ByteBuf)buf)).get();
            }
        });
    }
}

