/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemTrowel
extends ItemBase
implements IAgriTrowelItem,
IItemWithModel,
IRecipeRegister {
    @AgriConfigurable(category=AgriConfigCategory.TOOLS, key="Enable Trowel", comment="Set to false to disable the Trowel.")
    public static boolean enableTrowel = true;

    public ItemTrowel() {
        super("trowel");
        this.field_77777_bU = 1;
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT);
    }

    public boolean func_82788_x() {
        return true;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitx, float hity, float hitz) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IAgriCrop) {
            IAgriCrop crop = (IAgriCrop)te;
            Optional<AgriSeed> seed = AgriApi.getSeedRegistry().valueOf(stack);
            if (crop.hasSeed() && !seed.isPresent()) {
                seed = Optional.ofNullable(crop.getSeed());
                crop.setSeed(null);
                if (seed.isPresent()) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("agri_seed", seed.get().getPlant().getId());
                    seed.get().getStat().writeToNBT(tag);
                    stack.func_77982_d(tag);
                    stack.func_77964_b(1);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            if (seed.isPresent() && !crop.hasSeed()) {
                if (crop.setSeed(seed.get())) {
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77964_b(0);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean isEnabled() {
        return enableTrowel;
    }

    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        return ImmutableList.of((Object)new Tuple((Object)0, (Object)new ModelResourceLocation(this.getRegistryName() + "")), (Object)new Tuple((Object)1, (Object)new ModelResourceLocation(this.getRegistryName() + "_full")));
    }

    public void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"  s", "ii ", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "ingotIron"}));
    }
}

