/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.crafting.RecipeCopyJournal;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegister;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemJournal
extends ItemBase
implements IAgriJournalItem,
IItemWithModel,
IRecipeRegister {
    public ItemJournal() {
        super("journal");
        this.func_77625_d(1);
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)AgriCraft.instance, 2, world, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        list.add(AgriCore.getTranslator().translate("agricraft_tooltip.discoveredSeeds") + ": " + this.getDiscoveredSeedIds(stack).count());
    }

    private Stream<String> getDiscoveredSeedIds(@Nullable ItemStack journal) {
        return Optional.ofNullable(journal).map(ItemStack::func_77978_p).map(tag -> tag.func_74779_i("agri_discovered")).map(ids -> ids.split(";")).map(Arrays::stream).orElseGet(Stream::empty);
    }

    @Override
    public void addEntry(@Nullable ItemStack journal, @Nullable IAgriPlant plant) {
        if (journal != null && plant != null && !this.isSeedDiscovered(journal, plant)) {
            NBTTagCompound tag = StackHelper.getTag(journal);
            String old = tag.func_74779_i("agri_discovered");
            tag.func_74778_a("agri_discovered", old + plant.getId() + ";");
            journal.func_77982_d(tag);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSeedDiscovered(@Nullable ItemStack journal, @Nullable IAgriPlant plant) {
        if (journal == null) return false;
        if (plant == null) return false;
        if (!this.getDiscoveredSeedIds(journal).anyMatch(plant.getId()::equals)) return false;
        return true;
    }

    @Override
    public List<IAgriPlant> getDiscoveredSeeds(@Nullable ItemStack journal) {
        return Optional.ofNullable(journal).map(this::getDiscoveredSeedIds).orElseGet(Stream::empty).map(AgriApi.getPlantRegistry()::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe((Item)this, new Object[]{"csc", "sbs", "csc", Character.valueOf('c'), AgriItems.getInstance().CROPS, Character.valueOf('s'), Items.field_151014_N, Character.valueOf('b'), Items.field_151122_aG}));
        RecipeSorter.register((String)"recipe.copy_journal", RecipeCopyJournal.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        GameRegistry.addRecipe((IRecipe)new RecipeCopyJournal());
    }
}

