/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.v1.mutation.IAgriMutationEngine;
import com.infinityraider.agricraft.farming.mutation.MutateStrategy;
import com.infinityraider.agricraft.farming.mutation.SpreadStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;

public final class AgriMutationEngine
implements IAgriMutationEngine {
    private final List<Tuple<Double, IAgriCrossStrategy>> strategies = new ArrayList<Tuple<Double, IAgriCrossStrategy>>();
    private double sigma = 0.0;

    public AgriMutationEngine() {
        this.registerStrategy(new MutateStrategy());
        this.registerStrategy(new SpreadStrategy());
    }

    @Override
    public boolean registerStrategy(IAgriCrossStrategy strategy) {
        if (strategy.getRollChance() > 1.0 || strategy.getRollChance() < 0.0) {
            throw new IndexOutOfBoundsException("Invalid roll chance of " + strategy.getRollChance() + "!\nThe roll chance must be in the range 0.0 (inclusive) to 1.0 (exclusive)!");
        }
        if (strategy.getRollChance() == 0.0) {
            AgriCore.getLogger("agricraft").debug("Skipping mutation strategy with zero chance!", new Object[0]);
            return false;
        }
        if (this.hasStrategy(strategy)) {
            AgriCore.getLogger("agricraft").debug("Skipping duplicate mutation strategy!", new Object[0]);
            return false;
        }
        this.sigma += strategy.getRollChance();
        this.strategies.add((Tuple<Double, IAgriCrossStrategy>)new Tuple((Object)this.sigma, (Object)strategy));
        return true;
    }

    @Override
    public boolean hasStrategy(IAgriCrossStrategy strategy) {
        return this.strategies.stream().anyMatch(t -> ((IAgriCrossStrategy)t.func_76340_b()).equals(strategy));
    }

    @Override
    public List<IAgriCrossStrategy> getStrategies() {
        return this.strategies.stream().map(t -> (IAgriCrossStrategy)t.func_76340_b()).collect(Collectors.toList());
    }

    @Override
    public Optional<IAgriCrossStrategy> rollStrategy(Random rand) {
        double value = rand.nextDouble() * this.sigma;
        return this.strategies.stream().filter(t -> value <= (Double)t.func_76341_a()).map(t -> (IAgriCrossStrategy)t.func_76340_b()).findFirst();
    }
}

