/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.v1.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.reference.AgriCraftConfig;
import com.infinityraider.agricraft.utility.StackHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class ItemToolTipHandler {
    private static final ItemToolTipHandler INSTANCE = new ItemToolTipHandler();

    public static ItemToolTipHandler getInstance() {
        return INSTANCE;
    }

    private ItemToolTipHandler() {
    }

    @SubscribeEvent
    public void addSeedStatsTooltip(ItemTooltipEvent event) {
        AgriSeed seed;
        ItemStack stack = event.getItemStack();
        if (stack != null && (seed = (AgriSeed)AgriApi.getSeedRegistry().valueOf(stack).orElse(null)) != null) {
            if (seed.getStat().isAnalyzed()) {
                seed.getStat().addStats(event.getToolTip()::add);
            } else {
                event.getToolTip().add(" " + AgriCore.getTranslator().translate("agricraft_tooltip.unidentified"));
            }
        }
    }

    @SubscribeEvent
    public void addNbtInfo(ItemTooltipEvent event) {
        if (AgriCraftConfig.enableNBTTooltips) {
            event.getToolTip().add(ChatFormatting.DARK_AQUA + "NBT:");
            if (StackHelper.hasTag(event.getItemStack())) {
                NBTTagCompound tag = StackHelper.getTag(event.getItemStack());
                for (String key : tag.func_150296_c()) {
                    event.getToolTip().add(ChatFormatting.DARK_AQUA + " - " + key + ": " + tag.func_74781_a(key).toString());
                }
            } else {
                event.getToolTip().add(ChatFormatting.DARK_AQUA + " - No NBT Tags");
            }
        }
    }

    @SubscribeEvent
    public void addOreDictInfo(ItemTooltipEvent event) {
        if (AgriCraftConfig.enableOreDictTooltips) {
            int[] ids;
            event.getToolTip().add(ChatFormatting.DARK_AQUA + "OreDict:");
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)event.getItemStack())) {
                event.getToolTip().add(ChatFormatting.DARK_AQUA + " - " + OreDictionary.getOreName((int)id) + " (" + id + ")");
            }
            if (ids.length == 0) {
                event.getToolTip().add(ChatFormatting.DARK_AQUA + " - No OreDict Entries");
            }
        }
    }

    @SubscribeEvent
    public void addTrowelTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b() instanceof IAgriTrowelItem) {
            AgriSeed seed = AgriApi.getSeedRegistry().valueOf(event.getItemStack()).orElse(null);
            if (seed != null) {
                event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.seed") + ": " + seed.getPlant().getSeedName());
            } else {
                event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.trowel"));
            }
        }
    }

    @SubscribeEvent
    public void addClipperTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (StackHelper.isValid(stack, IAgriClipperItem.class)) {
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper1"));
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper2"));
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper3"));
        }
    }
}

