/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui;

import com.infinityraider.agricraft.gui.AgriGuiWrapper;
import com.infinityraider.agricraft.gui.IAgriGui;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import scala.actors.threadpool.Arrays;

public class ComponentGui<T extends Container>
implements IAgriGui<T> {
    private final int width;
    private final int height;
    private List<GuiComponent> components;
    private List<ResourceLocation> backgrounds;
    private final T container;
    private int lastMouseX;
    private int lastMouseY;

    public ComponentGui(int width, int height, T container) {
        this.width = width;
        this.height = height;
        this.components = new ArrayList<GuiComponent>();
        this.backgrounds = new ArrayList<ResourceLocation>();
        this.container = container;
        this.lastMouseX = -1;
        this.lastMouseY = -1;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    public final void resetMouse() {
        this.lastMouseX = -1;
        this.lastMouseY = -1;
    }

    public final synchronized List<GuiComponent> getComponents() {
        return new ArrayList<GuiComponent>(this.components);
    }

    public final synchronized List<ResourceLocation> getBackgrounds() {
        return new ArrayList<ResourceLocation>(this.backgrounds);
    }

    public final synchronized boolean addComponent(GuiComponent component) {
        return this.components.add(component);
    }

    public final synchronized boolean addBackground(ResourceLocation background) {
        return this.backgrounds.add(background);
    }

    public final synchronized boolean addComponents(GuiComponent ... components) {
        return this.components.addAll(Arrays.asList((Object[])components));
    }

    public final synchronized boolean addBackgrounds(ResourceLocation ... backgrounds) {
        return this.backgrounds.addAll(Arrays.asList((Object[])backgrounds));
    }

    public final synchronized boolean addComponents(Collection<GuiComponent> components) {
        return this.components.addAll(components);
    }

    public final synchronized boolean addBackgrounds(Collection<ResourceLocation> backgrounds) {
        return this.backgrounds.addAll(backgrounds);
    }

    public final synchronized boolean removeComponent(GuiComponent component) {
        return this.components.remove(component);
    }

    public final synchronized boolean removeBackground(ResourceLocation background) {
        return this.backgrounds.remove(background);
    }

    public final synchronized void clearComponents() {
        this.components = new ArrayList<GuiComponent>();
    }

    public final synchronized void clearBackgrounds() {
        this.backgrounds = new ArrayList<ResourceLocation>();
    }

    @Override
    public final synchronized void onGuiInit(AgriGuiWrapper wrapper) {
        this.resetMouse();
        this.onComponentGuiInit(wrapper);
    }

    protected void onComponentGuiInit(AgriGuiWrapper wrapper) {
    }

    @Override
    public final synchronized void onRenderBackground(AgriGuiWrapper wrapper, float f, int relMouseX, int relMouseY) {
        GlStateManager.func_179123_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ResourceLocation r : this.backgrounds) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
            wrapper.func_73729_b(0, 0, 0, 0, this.width, this.height);
        }
        GlStateManager.func_179099_b();
    }

    @Override
    public final synchronized void onRenderForeground(AgriGuiWrapper wrapper, List<String> tooltips, int relMouseX, int relMouseY) {
        this.components.stream().filter(c -> c.isVisable()).peek(c -> c.renderComponent(wrapper)).filter(c -> c.contains(relMouseX, relMouseY)).forEach(c -> c.addToolTip(tooltips, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
    }

    @Override
    public final synchronized void onMouseClicked(AgriGuiWrapper wrapper, int relMouseX, int relMouseY, int mouseButton) {
        this.components.stream().filter(c -> c.isEnabled()).filter(c -> c.contains(relMouseX, relMouseY)).anyMatch(c -> c.onClick(relMouseX, relMouseY, mouseButton));
    }

    @Override
    public final synchronized void onUpdateMouse(AgriGuiWrapper wrapper, List<String> tooltips, int relMouseX, int relMouseY) {
        if (this.lastMouseX != relMouseX || this.lastMouseY != relMouseY) {
            this.components.stream().filter(c -> c.isEnabled()).forEach(c -> c.onMouseMove(relMouseX, relMouseY));
            this.lastMouseX = relMouseX;
            this.lastMouseY = relMouseY;
        }
    }
}

