/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.crafting;

import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import com.infinityraider.agricraft.crafting.FullRecipeLayout;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.agricraft.utility.StackHelper;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class CustomWoodShapedRecipe
implements IRecipe {
    final ItemStack result;
    final FullRecipeLayout layout;

    public CustomWoodShapedRecipe(ItemStack result, FullRecipeLayout layout) {
        this.result = result;
        this.layout = layout;
    }

    public boolean func_77569_a(InventoryCrafting ic, World world) {
        Optional<CustomWoodType> material = this.inferMaterial(ic);
        if (!material.isPresent()) {
            return false;
        }
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                FuzzyStack expected = this.layout.get(r, c);
                ItemStack input = ic.func_70463_b(r, c);
                Optional<CustomWoodType> inputMaterial = CustomWoodTypeRegistry.getFromStack(input);
                if (inputMaterial.isPresent() && !material.equals(inputMaterial)) {
                    return false;
                }
                if (Objects.equals(input, expected)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting ic) {
        Optional<CustomWoodType> material = this.inferMaterial(ic);
        if (material.isPresent()) {
            ItemStack instance = this.result.func_77946_l();
            NBTTagCompound tag = StackHelper.getTag(instance);
            material.get().writeToNBT(tag);
            instance.func_77982_d(tag);
            return instance;
        }
        return null;
    }

    public int func_77570_a() {
        return 9;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ItemStack[] func_179532_b(InventoryCrafting ic) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)ic);
    }

    public Optional<CustomWoodType> inferMaterial(InventoryCrafting ic) {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                ItemStack stack = ic.func_70463_b(r, c);
                Optional<CustomWoodType> material = CustomWoodTypeRegistry.getFromStack(stack);
                if (!material.isPresent()) continue;
                return material;
            }
        }
        return Optional.empty();
    }
}

