/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.crafting;

import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.agricraft.utility.CustomWoodTypeRegistry;
import com.infinityraider.agricraft.utility.StackHelper;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class CustomWoodRecipeHelper {
    public static final String MATERIAL_PARAMETER = "MATERIAL_PARAMETER";

    public static void registerCustomWoodRecipe(Block block, int amount, boolean shaped, Object ... params) {
        CustomWoodTypeRegistry.getAllTypes().forEach(type -> CustomWoodRecipeHelper.registerCustomWoodRecipeVariant(type, new ItemStack(block, amount), shaped, params));
    }

    public static void registerCustomWoodRecipe(ItemStack result, boolean shaped, Object ... params) {
        CustomWoodTypeRegistry.getAllTypes().forEach(type -> CustomWoodRecipeHelper.registerCustomWoodRecipeVariant(type, result, shaped, params));
    }

    public static void registerCustomWoodRecipeVariant(CustomWoodType material, ItemStack result, boolean shaped, Object ... params) {
        Object[] ingredients = Arrays.copyOf(params, params.length);
        for (int i = 0; i < ingredients.length; ++i) {
            if (ingredients[i] instanceof Block) {
                ingredients[i] = new ItemStack((Block)ingredients[i]);
            } else if (ingredients[i] instanceof Item) {
                ingredients[i] = new ItemStack((Item)ingredients[i]);
            }
            if (Objects.equals(MATERIAL_PARAMETER, ingredients[i])) {
                ingredients[i] = material.getStack();
                continue;
            }
            if (!(ingredients[i] instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)ingredients[i];
            NBTTagCompound tag = StackHelper.getTag(stack);
            material.writeToNBT(tag);
            stack.func_77982_d(tag);
        }
        NBTTagCompound tag = StackHelper.getTag(result);
        material.writeToNBT(tag);
        result.func_77982_d(tag);
        if (shaped) {
            GameRegistry.addShapedRecipe((ItemStack)result, (Object[])ingredients);
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])ingredients);
        }
    }
}

